/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.navi.view.statusbar;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.text.TextUtils;

public class StatusBarBatteryStateReceiver
extends BroadcastReceiver {
    private OnBatteryChangedCallback mOnBatteryChangedCallback = null;

    public void onReceive(Context context, Intent intent) {
        if (TextUtils.equals((CharSequence)intent.getAction(), (CharSequence)"android.intent.action.BATTERY_CHANGED")) {
            int n2 = intent.getExtras().getInt("level");
            int n3 = intent.getExtras().getInt("scale");
            n2 = n2 * 100 / n3;
            int n4 = intent.getIntExtra("status", -1);
            if (n4 == 1 || n4 == 2 || n4 == 3 || n4 == 4 || n4 == 5) {
                if (n4 == 2 || n4 == 5) {
                    if (this.mOnBatteryChangedCallback != null) {
                        this.mOnBatteryChangedCallback.onBatteryCharging(n2);
                        return;
                    }
                } else if (this.mOnBatteryChangedCallback != null) {
                    this.mOnBatteryChangedCallback.onBatteryNormal(n2);
                }
            }
        }
    }

    public void setOnBatteryChangedCallback(OnBatteryChangedCallback onBatteryChangedCallback) {
        this.mOnBatteryChangedCallback = onBatteryChangedCallback;
    }

    public void register(Context context) {
        if (context != null) {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.BATTERY_CHANGED");
            try {
                context.registerReceiver((BroadcastReceiver)this, intentFilter);
                return;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public void unRegister(Context context) {
        try {
            if (context != null) {
                try {
                    context.unregisterReceiver((BroadcastReceiver)this);
                    return;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public static interface OnBatteryChangedCallback {
        public void onBatteryNormal(int var1);

        public void onBatteryCharging(int var1);
    }
}

