/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.navi.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import com.amap.api.col.3nsl.fe;
import com.amap.api.col.3nsl.hz;
import com.amap.api.navi.model.AMapTrafficStatus;
import java.util.Arrays;
import java.util.List;

public class TmcBarView
extends View {
    private static final int DISTANCE_MIN = 10;
    private static final int DISTANCE_MID = 5000;
    private static final int DISTANCE_MAX = 50000;
    private int unknownTrafficColor;
    private int smoothTrafficColor;
    private int slowTrafficColor;
    private int jamTrafficColor;
    private int veryJamTrafficColor;
    private Paint mPaint;
    private List<AMapTrafficStatus> mTmcBarItems;
    private int mRouteTotalLength;
    private float mCursorPos;
    private TmcBarListener mTmcBarListener;
    private final TmcTag mTagCache = new TmcTag();
    private int mPathHeight;
    private Path mPath = new Path();
    private float[] radiusArray = new float[8];
    private ImageView mDefaultTmcBarCarView = null;
    private int mCarHeight = 0;
    private float mCursorRatio = 1.0f;

    public TmcBarView(Context context) {
        super(context);
        this.init();
    }

    public TmcBarView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init();
    }

    public TmcBarView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.init();
    }

    private void init() {
        if (Build.VERSION.SDK_INT < 18) {
            this.setLayerType(1, null);
        }
    }

    public void setData(List<AMapTrafficStatus> list, int n2) {
        this.mTmcBarItems = list;
        this.mRouteTotalLength = n2;
    }

    public void setCarView(ImageView imageView) {
        this.mDefaultTmcBarCarView = imageView;
        if (this.mDefaultTmcBarCarView != null) {
            this.mCarHeight = hz.a(this.getContext(), 20);
        }
    }

    public void setCursorPos(int n2) {
        this.mCursorRatio = (float)n2 * 1.0f / ((float)this.mRouteTotalLength * 1.0f);
    }

    protected void onDraw(Canvas canvas) {
        try {
            int n2 = this.getWidth();
            int n3 = this.getHeight();
            int n4 = n3 - this.mCarHeight;
            if (this.mCursorRatio > 1.0f) {
                this.mCursorRatio = 1.0f;
            }
            this.mCursorPos = this.mCursorRatio * (float)n4;
            if (this.mDefaultTmcBarCarView != null) {
                this.mDefaultTmcBarCarView.setTranslationY(this.mCursorPos);
                this.mDefaultTmcBarCarView.invalidate();
            }
            if (this.mTmcBarItems != null && n3 > 0) {
                int n5;
                if (this.mPathHeight != n3) {
                    this.mPath.reset();
                    Arrays.fill(this.radiusArray, (float)n2 / 2.0f);
                    this.mPath.addRoundRect(new RectF(0.0f, 0.0f, (float)n2, (float)n3), this.radiusArray, Path.Direction.CW);
                    this.mPathHeight = n3;
                }
                canvas.save();
                canvas.clipPath(this.mPath);
                float f2 = 0.0f;
                float f3 = (float)n4 * 1.0f / ((float)this.mRouteTotalLength * 1.0f);
                for (n5 = this.mTmcBarItems.size() - 1; n5 >= 0; --n5) {
                    AMapTrafficStatus aMapTrafficStatus = this.mTmcBarItems.get(n5);
                    float f4 = (float)Math.round((float)aMapTrafficStatus.getLength() * f3 * 100.0f) * 0.01f;
                    TmcBarView tmcBarView = this;
                    canvas.drawRect(0.0f, (f2 += f4) - f4, (float)n2, f2, tmcBarView.getPaintInColor(tmcBarView.getColor(aMapTrafficStatus.getStatus())));
                }
                n5 = n4 + (this.mCarHeight >> 1);
                if (f2 < (float)n5) {
                    TmcBarView tmcBarView = this;
                    canvas.drawRect(0.0f, f2, (float)n2, (float)n5, tmcBarView.getPaintInColor(tmcBarView.getColor(this.mTmcBarItems.get(0).getStatus())));
                }
                if ((float)n3 > this.mCursorPos) {
                    TmcBarView tmcBarView = this;
                    canvas.drawRect(0.0f, this.mCursorPos + (float)(this.mCarHeight >> 1), (float)n2, (float)n3, tmcBarView.getPaintInColor(tmcBarView.getColor(-1)));
                }
                if (this.mTmcBarListener != null) {
                    this.mTmcBarListener.dismissBottomTag();
                }
                canvas.restore();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    private Paint getPaintInColor(int n2) {
        if (this.mPaint == null) {
            this.mPaint = new Paint();
            this.mPaint.setAntiAlias(true);
            this.mPaint.setStyle(Paint.Style.FILL);
        }
        this.mPaint.setColor(n2);
        return this.mPaint;
    }

    public void setUnknownTrafficColor(int n2) {
        this.unknownTrafficColor = n2;
    }

    public void setSmoothTrafficColor(int n2) {
        this.smoothTrafficColor = n2;
    }

    public void setSlowTrafficColor(int n2) {
        this.slowTrafficColor = n2;
    }

    public void setJamTrafficColor(int n2) {
        this.jamTrafficColor = n2;
    }

    public void setVeryJamTrafficColor(int n2) {
        this.veryJamTrafficColor = n2;
    }

    private int getColor(int n2) {
        switch (n2) {
            case 0: {
                if (this.unknownTrafficColor != 0) {
                    return this.unknownTrafficColor;
                }
                return Color.rgb((int)fe.b.a(), (int)fe.b.b(), (int)fe.b.c());
            }
            case 1: {
                if (this.smoothTrafficColor != 0) {
                    return this.smoothTrafficColor;
                }
                return Color.rgb((int)fe.d.a(), (int)fe.d.b(), (int)fe.d.c());
            }
            case 2: {
                if (this.slowTrafficColor != 0) {
                    return this.slowTrafficColor;
                }
                return Color.rgb((int)fe.e.a(), (int)fe.e.b(), (int)fe.e.c());
            }
            case 3: {
                if (this.jamTrafficColor != 0) {
                    return this.jamTrafficColor;
                }
                return Color.rgb((int)fe.f.a(), (int)fe.f.b(), (int)fe.f.c());
            }
            case 4: {
                if (this.veryJamTrafficColor != 0) {
                    return this.veryJamTrafficColor;
                }
                return Color.rgb((int)fe.g.a(), (int)fe.g.b(), (int)fe.g.c());
            }
        }
        return Color.rgb((int)fe.a.a(), (int)fe.a.b(), (int)fe.a.c());
    }

    public void setTacBarListener(TmcBarListener tmcBarListener) {
        this.mTmcBarListener = tmcBarListener;
    }

    public static class TmcTag {
        public int status;
        public int translationY;
        public int roadLength;
        public int bgResId;
        public int textColor;
        public float viewHeight;
        public int index;
    }

    public static interface TmcBarListener {
        public void showBottomTag(TmcTag var1);

        public void dismissBottomTag();
    }
}

