/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.navi.view;

import android.content.Context;
import android.content.res.Resources;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.amap.api.col.3nsl.id;
import com.amap.api.navi.model.NaviPoi;
import com.amap.api.navi.view.PoiInputItemWidget;
import com.amap.api.navi.view.PoiInputResWidget;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class PoiInputSearchWidget
extends RelativeLayout
implements View.OnClickListener {
    public static final int DEF_ANIMATION_DURATION = 150;
    private View mBackBtn;
    private View mAddBtn;
    private View mSwitchBtn;
    private View mFinishChooseMidBtn;
    private PoiInputItemWidget mStartInputWidget;
    private PoiInputItemWidget mDestInputWidget;
    private ArrayList<PoiInputItemWidget> mMidInputWidgets = new ArrayList();
    private PoiInputResWidget mPoiInputResWidget;
    private LinearLayout mMidItemWidgetGroup;
    private NaviPoi mStartPoi;
    private NaviPoi mDestPoi;
    private ArrayList<NaviPoi> mMidPois = new ArrayList();
    private int mMaxMidNum = 3;
    private Resources mResources;
    private PoiInputItemWidget.Callback mInputItemCallback = new PoiInputItemWidget.Callback(){

        @Override
        public final void onClick(PoiInputItemWidget poiInputItemWidget) {
            try {
                if (PoiInputSearchWidget.this.mCallback != null) {
                    int n2 = -1;
                    if (poiInputItemWidget.getType() == 2) {
                        n2 = PoiInputSearchWidget.this.mMidInputWidgets.indexOf((Object)poiInputItemWidget);
                    }
                    PoiInputSearchWidget.this.mCallback.onClick(poiInputItemWidget.getType(), n2, poiInputItemWidget.getPoi());
                }
                return;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return;
            }
        }

        @Override
        public final void onDelete(PoiInputItemWidget poiInputItemWidget) {
            if (PoiInputSearchWidget.this.isInAnim.get()) {
                return;
            }
            int n2 = PoiInputSearchWidget.this.mMidInputWidgets.indexOf((Object)poiInputItemWidget);
            if (n2 < 0) {
                return;
            }
            if (PoiInputSearchWidget.this.mCallback != null) {
                PoiInputSearchWidget.this.mCallback.onDelete(n2, (NaviPoi)PoiInputSearchWidget.this.mMidPois.get(n2));
            }
            PoiInputSearchWidget.this.mMidPois.remove(n2);
            PoiInputSearchWidget.this.applyRemoveAnim((PoiInputItemWidget)((Object)PoiInputSearchWidget.this.mMidInputWidgets.get(n2)), n2);
            PoiInputSearchWidget.this.mMidInputWidgets.remove(n2);
            PoiInputSearchWidget.this.checkMidInputHintPosAndAddBtn();
        }

        @Override
        public final void onBack() {
            if (PoiInputSearchWidget.this.mCallback != null) {
                PoiInputSearchWidget.this.mCallback.onBack();
            }
        }

        @Override
        public final void onAddMid() {
            if (PoiInputSearchWidget.this.isInAnim.get()) {
                return;
            }
            PoiInputSearchWidget.this.appendMidInputWidget(null, true);
        }
    };
    private Callback mCallback;
    private AtomicBoolean isChooseMid = new AtomicBoolean(false);
    private AtomicBoolean isInCalRoute = new AtomicBoolean(false);
    private AtomicBoolean isInAnim = new AtomicBoolean(false);

    public PoiInputSearchWidget(Context context) {
        super(context);
        this.init();
    }

    public PoiInputSearchWidget(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init();
    }

    public PoiInputSearchWidget(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.init();
    }

    private void init() {
        id.a(this.getContext(), 2130903070, (ViewGroup)this);
        this.mResources = id.b(this.getContext());
        this.mStartInputWidget = (PoiInputItemWidget)this.findViewById(2147479843);
        this.mDestInputWidget = (PoiInputItemWidget)this.findViewById(2147479846);
        this.mMidItemWidgetGroup = (LinearLayout)this.findViewById(2147479845);
        this.mFinishChooseMidBtn = this.findViewById(2147479849);
        this.mPoiInputResWidget = (PoiInputResWidget)this.findViewById(2147479844);
        this.mBackBtn = this.findViewById(0x7FFFF117);
        this.mAddBtn = this.findViewById(2147479848);
        this.mSwitchBtn = this.findViewById(2147479847);
        this.mBackBtn.setOnClickListener((View.OnClickListener)this);
        this.mAddBtn.setOnClickListener((View.OnClickListener)this);
        this.mSwitchBtn.setOnClickListener((View.OnClickListener)this);
        this.mFinishChooseMidBtn.setOnClickListener((View.OnClickListener)this);
        this.mPoiInputResWidget.setOnClickListener(this);
    }

    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        super.dispatchTouchEvent(motionEvent);
        return true;
    }

    public boolean isFinishBtnVisible() {
        return this.mFinishChooseMidBtn.getVisibility() == 0;
    }

    public void initUI(NaviPoi object, NaviPoi naviPoi2, List<NaviPoi> list, int n2) {
        this.mStartPoi = object;
        this.mDestPoi = naviPoi2;
        this.mStartInputWidget.initUI(0, this.mStartPoi);
        this.mDestInputWidget.initUI(1, this.mDestPoi);
        this.mStartInputWidget.setCallback(this.mInputItemCallback);
        this.mDestInputWidget.setCallback(this.mInputItemCallback);
        this.mMidInputWidgets.clear();
        for (NaviPoi naviPoi2 : list) {
            this.appendMidInputWidget(naviPoi2, false);
        }
        this.checkIsToShowChooseRes();
        this.mMaxMidNum = n2;
    }

    public void setPoi(int n2, int n3, NaviPoi naviPoi) {
        PoiInputItemWidget poiInputItemWidget = this.findInputItemWidget(n2, n3);
        if (poiInputItemWidget == null) {
            return;
        }
        poiInputItemWidget.setPoi(naviPoi);
        if (n2 == 0) {
            this.mStartPoi = naviPoi;
            return;
        }
        if (n2 == 1) {
            this.mDestPoi = naviPoi;
            return;
        }
        this.mMidPois.set(n3, naviPoi);
    }

    public void isInRouteCal(boolean bl2) {
        this.isInCalRoute.set(bl2);
    }

    public boolean isAllInputItemsFilled() {
        if (this.mStartPoi == null) {
            return false;
        }
        if (this.mDestPoi == null) {
            return false;
        }
        Iterator<NaviPoi> iterator = this.mMidPois.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != null) continue;
            return false;
        }
        return true;
    }

    private PoiInputItemWidget findInputItemWidget(int n2, int n3) {
        switch (n2) {
            case 0: {
                return this.mStartInputWidget;
            }
            case 1: {
                return this.mDestInputWidget;
            }
            case 2: {
                if (n3 < 0 || n3 >= this.mMidInputWidgets.size()) {
                    return null;
                }
                PoiInputItemWidget poiInputItemWidget = this.mMidInputWidgets.get(n3);
                poiInputItemWidget.middle_index = this.mMidInputWidgets.size() > 1 ? n3 : -1;
                return poiInputItemWidget;
            }
        }
        return null;
    }

    private void appendMidInputWidget(NaviPoi naviPoi, boolean bl2) {
        PoiInputItemWidget poiInputItemWidget = new PoiInputItemWidget(this.getContext());
        poiInputItemWidget.initUI(2, naviPoi);
        poiInputItemWidget.setCallback(this.mInputItemCallback);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, (int)this.mResources.getDimension(0x7F070007));
        layoutParams.setMargins(0, (int)this.mResources.getDimension(2131165190), 0, 0);
        this.mMidInputWidgets.add(poiInputItemWidget);
        this.mMidPois.add(naviPoi);
        this.mMidItemWidgetGroup.addView((View)poiInputItemWidget, (ViewGroup.LayoutParams)layoutParams);
        if (bl2) {
            this.applyAddAnim(poiInputItemWidget, this.mMidInputWidgets.size() == this.mMaxMidNum);
        }
        this.checkMidInputHintPosAndAddBtn();
    }

    private void applyAddAnim(PoiInputItemWidget poiInputItemWidget, boolean bl2) {
        this.isInAnim.set(true);
        AlphaAnimation alphaAnimation = new AlphaAnimation(0.0f, 1.0f);
        alphaAnimation.setDuration(150L);
        alphaAnimation.setStartOffset(150L);
        poiInputItemWidget.setAnimation((Animation)alphaAnimation);
        alphaAnimation.setAnimationListener((Animation.AnimationListener)new AnimationListenerAdapter(){

            @Override
            public final void onAnimationEnd(Animation animation) {
                PoiInputSearchWidget.this.isInAnim.set(false);
            }
        });
        PoiInputSearchWidget poiInputSearchWidget = this;
        poiInputItemWidget = poiInputSearchWidget.createTransDownAnim(-poiInputSearchWidget.getInputWidgetHeightWithMargin());
        this.mDestInputWidget.setAnimation((Animation)poiInputItemWidget);
        this.mFinishChooseMidBtn.setAnimation((Animation)poiInputItemWidget);
        this.mSwitchBtn.setAnimation(this.createTransDownAnimForSwitchBtn());
        if (!bl2) {
            this.mAddBtn.setAnimation((Animation)poiInputItemWidget);
        }
    }

    private Animation createTransDownAnimForSwitchBtn() {
        TranslateAnimation translateAnimation = new TranslateAnimation(0.0f, 0.0f, -this.getInputWidgetHeightWithMargin() / 2.0f, 0.0f);
        translateAnimation.setDuration(150L);
        return translateAnimation;
    }

    private Animation createTransUpAnimForSwitchBtn() {
        TranslateAnimation translateAnimation = new TranslateAnimation(0.0f, 0.0f, 0.0f, -this.getInputWidgetHeightWithMargin() / 2.0f);
        translateAnimation.setDuration(150L);
        translateAnimation.setStartOffset(150L);
        return translateAnimation;
    }

    private Animation createTransUpAnim() {
        TranslateAnimation translateAnimation = new TranslateAnimation(0.0f, 0.0f, 0.0f, -this.getInputWidgetHeightWithMargin());
        translateAnimation.setDuration(150L);
        translateAnimation.setStartOffset(150L);
        return translateAnimation;
    }

    private Animation createTransDownAnim(float f2) {
        TranslateAnimation translateAnimation = new TranslateAnimation(0.0f, 0.0f, f2, 0.0f);
        translateAnimation.setDuration(150L);
        return translateAnimation;
    }

    private float getInputWidgetHeightWithMargin() {
        int n2 = this.mDestInputWidget.getHeight();
        float f2 = this.mResources.getDimension(2131165190);
        try {
            f2 = ((RelativeLayout.LayoutParams)this.mDestInputWidget.getLayoutParams()).topMargin;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return (float)n2 + f2;
    }

    private void applyRemoveAnim(final PoiInputItemWidget poiInputItemWidget, int n2) {
        this.isInAnim.set(true);
        AlphaAnimation alphaAnimation = new AlphaAnimation(1.0f, 0.0f);
        alphaAnimation.setDuration(150L);
        alphaAnimation.setFillAfter(true);
        poiInputItemWidget.startAnimation((Animation)alphaAnimation);
        alphaAnimation = this.createTransUpAnim();
        this.mDestInputWidget.startAnimation((Animation)alphaAnimation);
        this.mFinishChooseMidBtn.startAnimation(this.createTransUpAnim());
        this.mAddBtn.startAnimation(this.createTransUpAnim());
        this.mSwitchBtn.startAnimation(this.createTransUpAnimForSwitchBtn());
        ++n2;
        while (n2 < this.mMidInputWidgets.size()) {
            this.mMidInputWidgets.get(n2).setAnimation(this.createTransUpAnim());
            ++n2;
        }
        alphaAnimation.setAnimationListener((Animation.AnimationListener)new AnimationListenerAdapter(){

            @Override
            public final void onAnimationEnd(Animation animation) {
                PoiInputSearchWidget.this.mMidItemWidgetGroup.postDelayed(new Runnable(){

                    @Override
                    public final void run() {
                        try {
                            PoiInputSearchWidget.this.isInAnim.set(false);
                            PoiInputSearchWidget.this.mMidItemWidgetGroup.removeView((View)poiInputItemWidget);
                            return;
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                            return;
                        }
                    }
                }, 0L);
            }
        });
    }

    private void checkMidInputHintPosAndAddBtn() {
        this.checkMidInputHintPos();
        this.checkAddBtnVisible();
    }

    private void checkMidInputHintPos() {
        if (this.mMidInputWidgets.size() > 1) {
            for (int i2 = 0; i2 < this.mMidInputWidgets.size(); ++i2) {
                this.mMidInputWidgets.get(i2).setViaIndex(i2 + 1);
            }
            return;
        }
        if (this.mMidInputWidgets.size() == 1) {
            this.mMidInputWidgets.get(0).setViaIndex(-1);
        }
    }

    private void checkAddBtnVisible() {
        if (this.mMidInputWidgets.size() >= this.mMaxMidNum) {
            this.mAddBtn.setVisibility(8);
            return;
        }
        this.mAddBtn.setVisibility(0);
    }

    private void checkIsToShowChooseRes() {
        int n2 = 0;
        Iterator<NaviPoi> iterator = this.mMidPois.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() == null) continue;
            ++n2;
        }
        if (n2 > 0) {
            this.mPoiInputResWidget.setVisibility(0);
            this.mPoiInputResWidget.setPoi(this.mStartPoi, this.mDestPoi, this.mMidPois);
            this.mAddBtn.setVisibility(8);
            this.changePoiInputWidgets(false);
            return;
        }
        this.mAddBtn.setVisibility(0);
        this.changePoiInputWidgets(true);
    }

    private void changePoiInputWidgets(boolean bl2) {
        this.mStartInputWidget.setVisibility(bl2 ? 0 : 8);
        this.mDestInputWidget.setVisibility(bl2 ? 0 : 8);
        ArrayList<PoiInputItemWidget> arrayList = new ArrayList<PoiInputItemWidget>();
        ArrayList<NaviPoi> arrayList2 = new ArrayList<NaviPoi>();
        for (int i2 = 0; i2 < this.mMidInputWidgets.size(); ++i2) {
            if (this.mMidPois.get(i2) == null) {
                this.mMidItemWidgetGroup.removeView((View)this.mMidInputWidgets.get(i2));
                continue;
            }
            arrayList2.add(this.mMidPois.get(i2));
            arrayList.add(this.mMidInputWidgets.get(i2));
            this.mMidInputWidgets.get(i2).setVisibility(bl2 ? 0 : 8);
        }
        this.mMidInputWidgets = arrayList;
        this.mMidPois = arrayList2;
    }

    public void setCallback(Callback callback) {
        this.mCallback = callback;
    }

    public void setShowChooseRes() {
        if (this.mFinishChooseMidBtn.getVisibility() != 8) {
            this.mFinishChooseMidBtn.setVisibility(8);
        }
        if (this.mCallback != null) {
            this.isChooseMid.set(false);
        }
        this.checkIsToShowChooseRes();
    }

    public void onClick(View view) {
        try {
            if (this.isInAnim.get()) {
                return;
            }
            int n2 = view.getId();
            if (n2 == 0x7FFFF117) {
                if (this.mCallback != null) {
                    this.mCallback.onBack();
                    return;
                }
            } else if (n2 == 2147479848) {
                this.appendMidInputWidget(null, true);
                if (this.mFinishChooseMidBtn.getVisibility() != 0) {
                    this.mFinishChooseMidBtn.setVisibility(0);
                }
                if (this.mCallback != null && !this.isChooseMid.get()) {
                    this.mCallback.onStartChooseMid();
                    this.isChooseMid.set(true);
                    return;
                }
            } else if (n2 == 2147479849) {
                this.setShowChooseRes();
                if (this.mCallback != null) {
                    this.mCallback.onFinishChooseMid();
                    return;
                }
            } else {
                if (n2 == 2147479847) {
                    if (this.isInCalRoute.get()) {
                        if (this.mCallback != null) {
                            this.mCallback.onSwitchFail();
                        }
                        return;
                    }
                    this.applySwitchAnim();
                    return;
                }
                if (n2 == 2147479844) {
                    this.mFinishChooseMidBtn.setVisibility(0);
                    if (this.mCallback != null) {
                        this.mCallback.onStartChooseMid();
                        this.isChooseMid.set(false);
                    }
                    this.mPoiInputResWidget.setVisibility(8);
                    this.changePoiInputWidgets(true);
                    this.checkAddBtnVisible();
                }
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    private void applySwitchData() {
        this.mStartInputWidget.setPoi(this.mDestPoi);
        this.mDestInputWidget.setPoi(this.mStartPoi);
        Object object = this.mStartPoi;
        this.mStartPoi = this.mDestPoi;
        this.mDestPoi = object;
        object = new ArrayList();
        for (int i2 = 0; i2 < this.mMidInputWidgets.size(); ++i2) {
            this.mMidInputWidgets.get(i2).setPoi(this.mMidPois.get(this.mMidPois.size() - 1 - i2));
            ((ArrayList)object).add(this.mMidPois.get(this.mMidPois.size() - 1 - i2));
        }
        this.checkMidInputHintPos();
        this.mMidPois = object;
        this.isInAnim.set(false);
    }

    private void applySwitchAnim() {
        if (this.mCallback != null && !this.mCallback.onSwitch()) {
            return;
        }
        this.isInAnim.set(true);
        if (this.mPoiInputResWidget.getVisibility() == 0) {
            this.applySwitchData();
            this.mPoiInputResWidget.setPoi(this.mStartPoi, this.mDestPoi, this.mMidPois);
            return;
        }
        this.mStartInputWidget.switchAnim(1, new Runnable(){

            @Override
            public final void run() {
                try {
                    PoiInputSearchWidget.this.applySwitchData();
                    return;
                }
                catch (Throwable throwable) {
                    return;
                }
            }
        });
        this.mDestInputWidget.switchAnim(0, null);
        for (int i2 = 0; i2 < this.mMidInputWidgets.size(); ++i2) {
            int n2 = this.mMidInputWidgets.size() - 1 - i2;
            if (n2 == i2) continue;
            if (i2 < n2) {
                this.mMidInputWidgets.get(i2).switchAnim(1, null);
                continue;
            }
            this.mMidInputWidgets.get(i2).switchAnim(0, null);
        }
    }

    public static class AnimationListenerAdapter
    implements Animation.AnimationListener {
        public void onAnimationStart(Animation animation) {
        }

        public void onAnimationEnd(Animation animation) {
        }

        public void onAnimationRepeat(Animation animation) {
        }
    }

    public static interface Callback {
        public void onClick(int var1, int var2, NaviPoi var3);

        public void onDelete(int var1, NaviPoi var2);

        public void onBack();

        public boolean onSwitch();

        public void onSwitchFail();

        public void onStartChooseMid();

        public void onFinishChooseMid();
    }
}

