/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.navi.view;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.amap.api.col.3nsl.hz;
import com.amap.api.col.3nsl.id;
import com.amap.api.navi.AMapNaviView;
import com.amap.api.navi.model.AMapLaneInfo;

public class DriveWayView
extends LinearLayout {
    private int driveWayWidth = 0;
    private int driveWayHeight = 0;
    private int driveWaySize = 0;
    private int dividerWidth;
    private int[] driveWayBackgroundId = new int[]{2130839162, 2130839163, 2130839164, 2130839165, 2130839166, 2130839167, 2130839168, 2130839169, 2130839170, 2130839171, 2130839172, 2130839173, 2130839174, 2130839175, 2130839176, 2130839177, 2130839177, 2130839178, 2130839179, 2130839180, 2130839181, 2130839182, 2130839183, 2130839183, 2130839241, 2130839242};
    private int[] driveWayForegroundId = new int[]{2130839186, 2130839187, 2130839164, 2130839191, 2130839166, 2130839195, 2130839168, 2130839169, 2130839203, 2130839171, 2130839172, 2130839173, 2130839174, 2130839217, 2130839176, 2130839177, 2130839177, 2130839178, 2130839179, 2130839180, 2130839181, 2130839239, 2130839240, 2130839240, 2130839241, 2130839242};
    private AMapNaviView mAMapNaviView = null;
    LinearLayout.LayoutParams imgLp;
    LinearLayout.LayoutParams dividerLp;
    private Resources mResources;

    public DriveWayView(Context context) {
        this(context, null);
    }

    public DriveWayView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public DriveWayView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.mResources = id.b(context);
        this.driveWayWidth = hz.a(context, 36);
        this.driveWayHeight = hz.a(context, 56);
        this.driveWaySize = 0;
        this.dividerLp = new LinearLayout.LayoutParams(-2, this.driveWayHeight);
        this.dividerLp.gravity = 16;
        this.imgLp = new LinearLayout.LayoutParams(this.driveWayWidth, this.driveWayHeight);
        this.imgLp.gravity = 17;
        if (this.mResources != null && (context = this.mResources.getDrawable(2130837846)) != null) {
            this.dividerWidth = context.getIntrinsicWidth();
        }
        this.setGravity(1);
    }

    public void setAMapNaviView(AMapNaviView aMapNaviView) {
        this.mAMapNaviView = aMapNaviView;
    }

    public void loadDriveWayBitmap(byte[] byArray, byte[] byArray2) {
        try {
            this.removeAllViews();
            this.driveWaySize = this.parseDriveWaySize(byArray);
            if (this.driveWaySize == 0) {
                return;
            }
            for (int i2 = 0; i2 < this.driveWaySize; ++i2) {
                this.buildDriveWay(byArray[i2], byArray2[i2], i2, this.driveWaySize);
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public void loadDriveWayBitmap(AMapLaneInfo aMapLaneInfo) {
        try {
            this.removeAllViews();
            this.driveWaySize = aMapLaneInfo.laneCount;
            if (this.driveWaySize == 0) {
                return;
            }
            for (int i2 = 0; i2 < this.driveWaySize; ++i2) {
                this.buildDriveWay(aMapLaneInfo.backgroundLane[i2], aMapLaneInfo.frontLane[i2], i2, this.driveWaySize);
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    private int parseDriveWaySize(byte[] byArray) {
        int n2 = byArray.length;
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            if ((byArray[i2] & 0xFF) != 255) continue;
            n3 = i2;
            break;
        }
        return n3;
    }

    private boolean isThisLaneRecommended(int n2) {
        return n2 != 255;
    }

    private boolean isComplexLane(int n2) {
        return n2 == 14 || n2 == 2 || n2 == 4 || n2 == 9 || n2 == 10 || n2 == 11 || n2 == 12 || n2 == 6 || n2 == 7 || n2 == 16 || n2 == 17 || n2 == 18 || n2 == 19 || n2 == 20;
    }

    private int complexBitmap(int n2, int n3) {
        int n4 = 0;
        if (n2 == 10) {
            if (n3 == 0) {
                n4 = 2130839207;
            } else if (n3 == 8) {
                n4 = 2130839208;
            }
        } else if (n2 == 9) {
            if (n3 == 0) {
                n4 = 2130839204;
            } else if (n3 == 5) {
                n4 = 2130839205;
            }
        } else if (n2 == 2) {
            if (n3 == 0) {
                n4 = 2130839188;
            } else if (n3 == 1) {
                n4 = 2130839189;
            }
        } else if (n2 == 4) {
            if (n3 == 0) {
                n4 = 2130839192;
            } else if (n3 == 3) {
                n4 = 2130839193;
            }
        } else if (n2 == 6) {
            if (n3 == 1) {
                n4 = 2130839196;
            } else if (n3 == 3) {
                n4 = 2130839197;
            }
        } else if (n2 == 7) {
            if (n3 == 0) {
                n4 = 2130839199;
            } else if (n3 == 1) {
                n4 = 2130839200;
            } else if (n3 == 3) {
                n4 = 2130839201;
            }
        } else if (n2 == 11 || n2 == 14) {
            if (n3 == 5) {
                n4 = 2130839211;
            } else if (n3 == 1) {
                n4 = 2130839210;
            }
        } else if (n2 == 12) {
            if (n3 == 8) {
                n4 = 2130839214;
            } else if (n3 == 3) {
                n4 = 2130839213;
            }
        } else if (n2 == 16) {
            if (n3 == 0) {
                n4 = 2130839221;
            } else if (n3 == 1) {
                n4 = 2130839222;
            } else if (n3 == 5) {
                n4 = 2130839223;
            }
        } else if (n2 == 17) {
            if (n3 == 5) {
                n4 = 2130839226;
            } else if (n3 == 3) {
                n4 = 2130839225;
            }
        } else if (n2 == 18) {
            if (n3 == 1) {
                n4 = 2130839228;
            } else if (n3 == 5) {
                n4 = 2130839230;
            } else if (n3 == 3) {
                n4 = 2130839229;
            }
        } else if (n2 == 19) {
            if (n3 == 0) {
                n4 = 2130839232;
            } else if (n3 == 3) {
                n4 = 2130839233;
            } else if (n3 == 5) {
                n4 = 2130839234;
            }
        } else if (n2 == 21) {
            n4 = 2130839239;
        } else if (n2 == 23) {
            n4 = 2130839240;
        }
        n3 = n4;
        if (n3 == 0) {
            n3 = this.driveWayBackgroundId[n2];
        }
        return n3;
    }

    public void setDefaultTopMargin(int n2) {
        try {
            if (this.mAMapNaviView == null) {
                return;
            }
            n2 = !this.mAMapNaviView.isOrientationLandscape() && this.mAMapNaviView.isShowRoadEnlarge() ? n2 * 3 / 8 - (this.driveWayHeight >> 1) : (n2 += 10);
            RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.getLayoutParams();
            layoutParams.setMargins(0, n2, 0, 0);
            this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    private void buildDriveWay(int n2, int n3, int n4, int n5) {
        int n6 = n5 == 1 ? 2130839359 : (n5 > 1 && n4 == 0 ? 2130839358 : (n5 > 1 && n4 == n5 - 1 ? 2130839360 : 2130839357));
        if (this.isComplexLane(n2)) {
            n2 = this.complexBitmap(n2, n3);
            DriveWayView driveWayView = this;
            driveWayView.addView(driveWayView.createImageView(n2, n6), (ViewGroup.LayoutParams)this.imgLp);
        } else if (this.isThisLaneRecommended(n3)) {
            DriveWayView driveWayView = this;
            driveWayView.addView(driveWayView.createImageView(this.driveWayForegroundId[n3], n6), (ViewGroup.LayoutParams)this.imgLp);
        } else {
            DriveWayView driveWayView = this;
            driveWayView.addView(driveWayView.createImageView(this.driveWayBackgroundId[n2], n6), (ViewGroup.LayoutParams)this.imgLp);
        }
        if (n5 > 1 && n4 < n5 - 1) {
            DriveWayView driveWayView = this;
            driveWayView.addView(driveWayView.createLine(), (ViewGroup.LayoutParams)this.dividerLp);
        }
    }

    private View createImageView(int n2, int n3) {
        ImageView imageView = new ImageView(this.getContext());
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)this.mResources, (int)n2);
        imageView.setImageBitmap(bitmap);
        imageView.setBackground(this.mResources.getDrawable(n3));
        imageView.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        return imageView;
    }

    private View createLine() {
        ImageView imageView = new ImageView(this.getContext());
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)this.mResources, (int)2130837846);
        imageView.setImageBitmap(bitmap);
        imageView.setBackgroundColor(this.mResources.getColor(2131034170));
        return imageView;
    }

    public int getDriveWaySize() {
        return this.driveWaySize;
    }

    public int getDriveWayBgHeight() {
        return this.driveWayHeight;
    }

    public int getDriveWayWidth() {
        return this.driveWayWidth;
    }

    public int getDriveWaysWidth() {
        return this.driveWayWidth * this.driveWaySize + (this.driveWaySize - 1) * this.dividerWidth;
    }
}

