/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.idst.nui;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.AssetManager;
import android.os.Build;
import android.os.Environment;
import android.util.Log;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class CommonUtils {
    private static final String TAG = "CommonUtils";
    private static String targetDataDir = "asr_my";

    private static String getAssetsVersion(Context object) {
        try {
            int n2;
            object = object.getAssets().open("nui.json");
            byte[] byArray = new byte[4096];
            StringBuffer stringBuffer = new StringBuffer();
            while ((n2 = ((InputStream)object).read(byArray)) > 0) {
                stringBuffer.append(new String(byArray, 0, n2, "utf-8"));
            }
            ((InputStream)object).close();
            new StringBuilder("read nui.json==>").append(stringBuffer.toString());
            object = new JSONObject(stringBuffer.toString()).getString("assets_version");
            new StringBuilder("assets version is ").append(((String)object).toString());
            return object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static synchronized boolean copyAssetsData(Context object) {
        String string2 = CommonUtils.getModelPath(object);
        String string3 = CommonUtils.getAssetsVersion(object);
        AssetManager assetManager = object.getApplicationContext().getAssets();
        SharedPreferences sharedPreferences = object.getSharedPreferences("AliSR", 0);
        if (CommonUtils.shouldUpdateAssetsData(sharedPreferences, string3, object)) {
            object = CommonUtils.getCopyList(assetManager);
            if (!CommonUtils.copyList(assetManager, (List<String>)object, string2)) {
                return false;
            }
            sharedPreferences.edit().putString("version", string3).apply();
        }
        return true;
    }

    public static synchronized boolean copyAssetsToExplicitPath(Context context, String string2) {
        List<String> list;
        return CommonUtils.copyList((AssetManager)(context = context.getApplicationContext().getAssets()), list = CommonUtils.getCopyList((AssetManager)context), string2);
    }

    public static synchronized boolean copyTtsAssetsData(Context context) {
        List<String> list;
        String string2 = CommonUtils.getModelPath(context);
        return CommonUtils.copyList((AssetManager)(context = context.getApplicationContext().getAssets()), list = CommonUtils.getCopyList((AssetManager)context), string2);
    }

    public static synchronized boolean setExternalAssetFile(Context context, String string2) {
        String string3 = CommonUtils.getModelPath(context);
        return CommonUtils.copyFileOrDir(context.getApplicationContext().getAssets(), string2, string3 + "/" + string2);
    }

    public static String readContent(Context object, String string2) {
        try {
            int n2;
            object = object.getAssets().open(string2);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n2 = ((InputStream)object).read()) != -1) {
                byteArrayOutputStream.write(n2);
            }
            return byteArrayOutputStream.toString();
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("read asset file error , " + string2 + " , " + exception.toString()));
            return null;
        }
    }

    private static boolean shouldUpdateAssetsData(SharedPreferences sharedPreferences, String string2, Context object) {
        if (!new File((String)(object = CommonUtils.getModelPath(object)) + "/nui.json").exists()) {
            return true;
        }
        return !sharedPreferences.getString("version", "default").equals(string2);
    }

    public static boolean setTargetDataDir(String string2) {
        if (string2.length() == 0) {
            return false;
        }
        targetDataDir = string2;
        return true;
    }

    public static String getModelPath(Context context) {
        return context.getApplicationContext().getFilesDir().toString() + "/" + targetDataDir;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static List<String> getCopyList(AssetManager var0) {
        block17: {
            var1_2 = new ArrayList<String>();
            var2_4 = null;
            var3_5 = "copylist.txt";
            try {
                var4_6 /* !! */  = var0.list("");
                for (var5_11 = 0; var5_11 < var4_6 /* !! */ .length; ++var5_11) {
                    if (!var4_6 /* !! */ [var5_11].equals("ali_copylist.txt")) continue;
                    var3_5 = "ali_copylist.txt";
                    break;
                }
            }
            catch (IOException var4_7) {
                Log.e((String)"CommonUtils", (String)"cannot find file: ", (Throwable)var4_7);
            }
            try {
                var4_6 /* !! */  = var0.open(var3_5);
                var5_12 = new InputStreamReader((InputStream)var4_6 /* !! */ );
                var2_4 = new BufferedReader(var5_12);
                while ((var0 = var2_4.readLine()) != null) {
                    if (var0.trim().startsWith("#") || var0.trim().isEmpty()) continue;
                    var1_2.add((String)var0);
                }
                ** try [egrp 2[TRYBLOCK] [1 : 142->149)] { 
            }
            catch (IOException var4_9) {
                Log.e((String)"CommonUtils", (String)"Abort reading copy list file", (Throwable)var4_9);
                break block17;
            }
            finally {
                if (var2_4 != null) {
                    try {
                        var2_4.close();
                    }
                    catch (IOException var4_10) {
                        Log.e((String)"CommonUtils", (String)"Fail to close copy list file", (Throwable)var4_10);
                    }
                }
            }
lbl-1000:
            // 1 sources

            {
                var2_4.close();
            }
lbl27:
            // 1 sources

            catch (IOException var4_8) {
                Log.e((String)"CommonUtils", (String)"Fail to close copy list file", (Throwable)var4_8);
            }
            {
            }
        }
        return var1_2;
    }

    public static boolean copyList(AssetManager assetManager, List<String> object, String string2) {
        boolean bl2 = true;
        object = object.iterator();
        while (object.hasNext()) {
            String string3 = (String)object.next();
            bl2 = CommonUtils.copyFileOrDir(assetManager, string3, string2 + "/" + string3);
            if (bl2) continue;
            return bl2;
        }
        return bl2;
    }

    private static boolean copyFileOrDir(AssetManager assetManager, String string2, String string3) {
        boolean bl2 = true;
        try {
            String[] stringArray = assetManager.list(string2);
            if (stringArray.length == 0) {
                bl2 = true & CommonUtils.copyAsset(assetManager, string2, string3);
            } else {
                File file = new File(string3);
                if (!file.exists()) {
                    file.mkdirs();
                }
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    if (stringArray[i2].equals("") || stringArray[i2] == null || (bl2 = CommonUtils.copyFileOrDir(assetManager, string2 + "/" + stringArray[i2], string3 + "/" + stringArray[i2]))) continue;
                    return bl2;
                }
            }
            return bl2;
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)"Abort copying asset files", (Throwable)exception);
            return false;
        }
    }

    public static boolean copyAsset(Context context, String string2, String string3) {
        return CommonUtils.copyAsset(context.getApplicationContext().getAssets(), string2, string3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean copyAsset(AssetManager assetManager, String string2, String string3) {
        OutputStream outputStream;
        InputStream inputStream;
        block20: {
            inputStream = null;
            outputStream = null;
            if (string2.length() > 0 && string2.charAt(0) == '/') {
                string2 = string2.substring(1);
            }
            try {
                new StringBuilder("copying asset files from [").append(string2).append("] to [").append(string3).append("]");
                inputStream = assetManager.open(string2);
                new File(string3).createNewFile();
                outputStream = new FileOutputStream(string3);
                CommonUtils.copyFile(inputStream, outputStream);
                outputStream.flush();
                if (inputStream == null) break block20;
            }
            catch (Exception exception) {
                Log.e((String)TAG, (String)("Abort copying asset files from [" + string2 + "] to [" + string3 + "]"), (Throwable)exception);
                return false;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                Log.e((String)TAG, (String)String.valueOf(iOException));
            }
        }
        try {
            outputStream.close();
            return true;
        }
        catch (IOException iOException) {
            Log.e((String)TAG, (String)"", (Throwable)iOException);
        }
        return true;
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    Log.e((String)TAG, (String)String.valueOf(iOException));
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    Log.e((String)TAG, (String)"", (Throwable)iOException);
                }
            }
        }
    }

    private static void copyFile(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n2;
        byte[] byArray = new byte[1024];
        while ((n2 = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n2);
        }
    }

    public static byte[] getBytes(short[] sArray) {
        if (sArray == null) {
            return null;
        }
        int n2 = sArray.length;
        if (n2 == 0) {
            return null;
        }
        int n3 = n2;
        byte[] byArray = new byte[n3 + n3];
        int n4 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            short s2 = sArray[i2];
            byArray[n4++] = (byte)(s2 & 0xFF);
            byArray[n4++] = (byte)(s2 >> 8 & 0xFF);
        }
        return byArray;
    }

    public static int clamp(int n2, int n3, int n4) {
        if (n2 < n4) {
            if (n2 > n3) {
                return n2;
            }
            return n3;
        }
        return n4;
    }

    public static int getVoiceVolume(short[] sArray) {
        short s2 = 0;
        for (short s3 : sArray) {
            s3 = s3 < 0 ? -s3 : s3;
            if (s3 <= s2) continue;
            s2 = s3;
        }
        short s4 = (short)(s2 >> 7);
        s2 = s4;
        if (s4 > 100) {
            return 100;
        }
        return s2;
    }

    public static int[] bytesToInts(byte[] object) {
        IntBuffer intBuffer = ByteBuffer.wrap((byte[])object).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
        object = intBuffer;
        int[] nArray = new int[intBuffer.remaining()];
        ((IntBuffer)object).get(nArray);
        return nArray;
    }

    public static int getVoiceVolume(byte[] objectArray, int n2) {
        int[] nArray = CommonUtils.bytesToInts(objectArray);
        objectArray = nArray;
        int n3 = nArray.length / n2;
        long l2 = 0L;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (n2 != 1) {
                l2 += (long)(objectArray[i2 * n2 + 5] * objectArray[i2 * n2 + 5]);
                continue;
            }
            l2 += (long)(objectArray[i2 * n2] * objectArray[i2 * n2]);
        }
        return (int)(10.0 * Math.log10((double)l2 / ((double)n3 * 1.0)));
    }

    public static float clamp(float f2, float f3, float f4) {
        if (f2 < f4) {
            if (f2 > f3) {
                return f2;
            }
            return f3;
        }
        return f4;
    }

    private static boolean isFile(String string2) {
        return !string2.endsWith("/");
    }

    public static boolean shouldDebug() {
        String string2 = Environment.getExternalStorageDirectory().getPath() + "/AliSROpenDebugMode";
        return new File(string2).exists();
    }

    private static String[] getFileNames(Context context, String string2) {
        String[] stringArray = null;
        try {
            stringArray = context.getAssets().list(string2);
        }
        catch (IOException iOException) {
            Log.e((String)TAG, (String)"getFileNames: list ", (Throwable)iOException);
        }
        return stringArray;
    }

    public static String fillHardwareInfo(String string2) {
        String string3 = "";
        try {
            string2 = new JSONObject(string2);
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("manufacturer", (Object)Build.MANUFACTURER);
            jSONObject.put("brand", (Object)Build.BRAND);
            jSONObject.put("model", (Object)Build.MODEL);
            jSONObject.put("product", (Object)Build.PRODUCT);
            jSONObject.put("hardware", (Object)Build.HARDWARE);
            jSONObject.put("board", (Object)Build.BOARD);
            jSONObject.put("device", (Object)Build.DEVICE);
            jSONObject.put("display", (Object)Build.DISPLAY);
            string2.put("hardware_info", (Object)jSONObject.toString());
            string3 = string2.toString();
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return string3;
    }
}

