package com.sd.api.ui.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.Gravity;
import android.widget.ImageView;
import android.widget.LinearLayout;

import androidx.core.content.ContextCompat;


import com.minedata.minenavi.mapdal.NativeEnv;
import com.minedata.minenavi.navi.LaneDetector;
import com.msmap.api.R;

import java.io.InputStream;
import java.util.ArrayList;

@SuppressLint({"NewApi"})
public class MyLaneView extends LinearLayout implements LaneDetector.OnLaneDetectorListener {
    private static final String ASSET_PREFIX = "land/";
    private LaneDetector mLaneDetector = null;
    private int mHeight = 0;
    private LaneDetector.LaneIconId[] mLaneIconIds = null;
    private Drawable mNormDraw = null;
    //图片间隔
    private int mIconMargin = 0;
    private ArrayList<LaneDetector.OnLaneDetectorListener> mListeners = new ArrayList();
    private Context context;
    private AssetManager assetManager;

    public MyLaneView(Context context) {
        super(context);
        this.init();
    }

    public MyLaneView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

//    public MyLaneView(Context context, AttributeSet attrs, int defStyle) {
//        super(context, attrs);
//        this.init();
//    }

    public void addListener(LaneDetector.OnLaneDetectorListener listener) {
        this.mListeners.add(listener);
    }

    public void removeListener(LaneDetector.OnLaneDetectorListener listener) {
        this.mListeners.remove(listener);
    }

    public void onLaneDetectorEvent(int event, Object data) {
        switch (event) {
            case 1:
                this.mLaneIconIds = (LaneDetector.LaneIconId[]) data;
//                this.updateCache((LaneDetector.LaneIconId[]) data);
                this.layoutLanes();
            case 2:
            default:
                for (LaneDetector.OnLaneDetectorListener onLaneDetectorListener : this.mListeners) {
                    onLaneDetectorListener.onLaneDetectorEvent(event, data);
                }

        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
//        this.mHeight = this.getHeight();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mHeight = this.getMeasuredHeight();
//        this.mWidget = getMeasuredWidth();
    }

    private void init() {
        setOrientation(LinearLayout.HORIZONTAL);
        this.context = getContext();
        assetManager = context.getAssets();
        this.mLaneDetector = new LaneDetector();
        this.mLaneDetector.addListener(this);
        this.mNormDraw = ContextCompat.getDrawable(context, R.drawable.l2_1);
        this.mIconMargin = NativeEnv.dp2px(2.0F);
        this.setGravity(Gravity.CENTER_VERTICAL);
    }

    private void layoutLanes() {
        if (mLaneIconIds.length == 0)
            return;
        this.removeAllViews();
        this.layout();
//        this.layoutTest();
    }

    private void layout() {
        if (this.mHeight == 0) {
            this.mHeight = NativeEnv.dp2px(50.0F);
        }
        int iconHeight = this.mHeight - this.getPaddingTop() - this.getPaddingBottom();
        int iconWidth = iconHeight * this.mNormDraw.getIntrinsicWidth() / this.mNormDraw.getIntrinsicHeight();

        for (int i = 0; i < this.mLaneIconIds.length; ++i) {
            ImageView view = createLaneItemView(mLaneIconIds[i], iconWidth, iconHeight);
            if (view != null) {
                this.addView(view);
                if (i != this.mLaneIconIds.length - 1) {
                    this.addView(this.createSepView(iconHeight));
                }
            }
        }
    }

    private ImageView createLaneItemView(LaneDetector.LaneIconId iconId, int width, int height) {
        ImageView view = new ImageView(context);
        view.setAdjustViewBounds(true);
//        view.setScaleType(ImageView.ScaleType.CENTER_CROP);
        try {
            InputStream istr = assetManager.open(ASSET_PREFIX + iconId.lowerX + "-" + iconId.lowerY + ".png"); // 确保文件名和扩展名正确
            Drawable d = Drawable.createFromStream(istr, null);
            if (d != null) {
                view.setAdjustViewBounds(true);
                view.setScaleType(ImageView.ScaleType.CENTER_CROP);
                view.setImageDrawable(d);
                LayoutParams params = new LayoutParams(width, height);
                view.setLayoutParams(params);
            }
        } catch (Exception e) {
            return null;
        }
        return view;
    }


    private void layoutTest() {
        if (this.mHeight == 0) {
            this.mHeight = NativeEnv.dp2px(50.0F);
        }
        int len = 5;
        //        int iconHeight = this.mHeight - this.getPaddingTop() - this.getPaddingBottom();
//        int iconWidth = iconHeight * this.mNormBitmap.getIntrinsicWidth() / this.mNormBitmap.getIntrinsicHeight();
        int iconHeight = this.mHeight - this.getPaddingTop() - this.getPaddingBottom();
        int iconWidth = iconHeight * this.mNormDraw.getIntrinsicWidth() / this.mNormDraw.getIntrinsicHeight();
//        int sepWidth = NativeEnv.dp2px(1.0F);
//        int totalWidth = this.getPaddingLeft() + this.getPaddingRight() + (iconWidth + this.mIconMargin * 2) * 3 + sepWidth * (len - 1);
        for (int i = 0; i < len; ++i) {
            ImageView view = createLaneItemViewTest(iconWidth, iconHeight);
            if (view != null) {
                this.addView(view);
                if (i != len - 1) {
                    this.addView(this.createSepView(iconHeight));
                }
            }
        }

//        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -1);
//        params.width = totalWidth;
//        params.height = this.mHeight;
//        this.setLayoutParams(params);
//        this.setBackground(new NinePatchDrawable(this.getResources(), this.mBackgroudBitmap, this.mBackgroudBitmap.getNinePatchChunk(), new Rect(), (String) null));
    }

    private ImageView createLaneItemViewTest(int width, int height) {
        ImageView view = new ImageView(context);
        view.setAdjustViewBounds(true);
//        view.setScaleType(ImageView.ScaleType.CENTER_CROP);
        try {
            InputStream istr = assetManager.open(ASSET_PREFIX + "2-1.png"); // 确保文件名和扩展名正确
            Drawable d = Drawable.createFromStream(istr, null);
            if (d != null) {
                view.setImageDrawable(d);
            }
            LayoutParams params = new LayoutParams(width, height);
            view.setLayoutParams(params);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return view;
    }

    /**
     * 分割线
     **/
    private ImageView createSepView(int height) {
        ImageView view = new ImageView(context);
        ColorDrawable colorDrawable = new ColorDrawable(Color.parseColor("#99FFFFFF"));
        view.setBackground(colorDrawable);
        LayoutParams params = new LayoutParams(-2, -1);
        params.width = NativeEnv.dp2px(1.0F);
        params.height = height - NativeEnv.dp2px(2.0F);
        params.setMargins(this.mIconMargin, 0, this.mIconMargin, 0);
        view.setLayoutParams(params);
        return view;
    }

}
