package com.sd.api.intfaces

import com.minedata.minenavi.navi.GuidanceText
import com.minedata.minenavi.navi.NaviProgressData
import com.minedata.minenavi.navi.SmoothNaviData
import com.minedata.minenavi.navi.TmcSections

/**
 * 四维导航监听回调
 */
//四维的
interface OnNaviPresenterListener {

    /**
     * 车位置发生改变
     * @param ratio
     */
    fun onTracking(ratio: Float)

    /**
     *导航或者模拟导航时平滑跟踪
     */
    fun onSmoothTracking(data: SmoothNaviData)

    /**
     * 解析 naviProgressData 导航更新信息
     */
    fun onDataUpdated(naviProgressData: NaviProgressData)

    /**
     *解析 tmcSections 路况(TMC)信息条中的段信息
     */
    fun onTiBarUpdated(tmcSections: TmcSections)

    /**
     *解析 guidanceText 引导文字信息
     */
    fun onTextChanged(guidanceText: GuidanceText)

    /**
     *导航路口剩余距离
     */
    fun onDistanceChanged(distance: Int)

    /**
     *导航路口剩余距离
     *  目前是没有下一个引导点，距离路线距离10米，即为到达目的地。 有下一个引导点，下一个引导距此引导点距离在10米以内，到此引导距离在3米以内，也为到达目的地。
     */
    fun onArriveDestination()

    /**
     *导航结束
     */
    fun onNaviEnded()
}