package com.sd.api.factorys

import com.sd.api.bean.MSLatLng
import com.sd.api.bean.WayPoi
import com.sd.api.core.MapReadyView
import com.sd.api.core.basic.MSMarker
import com.sd.api.core.basic.MSOverlay
import com.sd.api.core.basic.OnDriveRoute
import com.sd.api.core.basic.OnMSPoiSearchLis
import com.sd.api.core.basic.OnMsGpsLoc
import com.sd.api.core.basic.amap.AmapDrawInMap
import com.sd.api.core.basic.amap.AmapGestures
import com.sd.api.core.basic.amap.AmapGpsLocation
import com.sd.api.core.basic.amap.AmapLocationStyle
import com.sd.api.core.basic.amap.AmapMethodAdv
import com.sd.api.core.basic.amap.AmapNai
import com.sd.api.core.basic.amap.AmapPoiSearch
import com.sd.api.core.basic.amap.AmapRoutePlans
import com.sd.api.core.basic.amap.AmapToggleLayers
import com.sd.api.intfaces.OnNaviPresenterListener

/**
 * 高德基础实现
 * IBasicMap
 */
class AmapBasic : IMapBasic {
    override fun toggleLayers(mapReadView: MapReadyView?, type: Int) {
        AmapToggleLayers.toggleLayers(mapReadView, type)
    }

    override fun setLocationStyle(
        mapReadView: MapReadyView?,
        type: Int
    ) {
        AmapLocationStyle.setLocationStyle(mapReadView, type)
    }

    override fun setRotateGesturesEnabled(
        mapReadView: MapReadyView?,
        enable: Boolean
    ) {
        AmapGestures.setRotateGesturesEnabled(mapReadView, enable)
    }

    override fun setTiltGesturesEnabled(
        mapReadView: MapReadyView?,
        enable: Boolean
    ) {
        AmapGestures.setTiltGesturesEnabled(mapReadView, enable)
    }

    override fun setMapCenter(
        mapReadView: MapReadyView?,
        lat: Double,
        lng: Double
    ) {
        AmapMethodAdv.setMapCenter(mapReadView, lat, lng)
    }

    override fun setMapZoom(mapReadView: MapReadyView?, zoom: Float) {
        AmapMethodAdv.setMapZoom(mapReadView, zoom)
    }

    override fun drawMarket(
        mapReadView: MapReadyView?,
        lat: Double,
        lng: Double
    ): MSMarker {
        return AmapDrawInMap.drawMarket(mapReadView, lat, lng)
    }

    override fun drawPolyline(
        mapReadView: MapReadyView?,
        msLatLng: List<MSLatLng>,
        width: Float,
        fcolor: Int,
        isDotted: Boolean
    ): MSOverlay {
        return AmapDrawInMap.drawPolyline(mapReadView, msLatLng, width, fcolor, isDotted)
    }

    override fun drawCircle(
        mapReadView: MapReadyView?,
        lat: Double,
        lng: Double,
        radius: Float,
        fillColor: Int,
        strokeColor: Int,
        strokeWidth: Float
    ): MSOverlay {
        return AmapDrawInMap.drawCircle(
            mapReadView,
            lat,
            lng,
            radius,
            fillColor,
            strokeColor,
            strokeWidth
        )
    }

    override fun drawPolygon(
        mapReadView: MapReadyView?,
        msLatLng: List<MSLatLng>,
        dLine: Boolean,
        fillColor: Int,
        strokeWidth: Float,
        strokeColor: Int
    ): MSOverlay {
        return AmapDrawInMap.drawPolygon(
            mapReadView,
            msLatLng,
            dLine,
            fillColor,
            strokeWidth,
            strokeColor
        )
    }

    override fun startPoiSearch(
        keyWord: String,
        lat: Double,
        lng: Double,
        onMSPoiSearchLis: OnMSPoiSearchLis
    ) {
        AmapPoiSearch.startPoiSearch(keyWord, lat, lng, onMSPoiSearchLis)
    }

    override fun startPoiSearchBound(
        keyWord: String,
        lat: Double,
        lng: Double,
        radios: Int,
        onMSPoiSearchLis: OnMSPoiSearchLis
    ) {
        AmapPoiSearch.startPoiSearchBound(keyWord, lat, lng, radios, onMSPoiSearchLis)
    }

    override fun startLoc(onMsGpsLoc: OnMsGpsLoc) {
        AmapGpsLocation.instance.starLoc(onMsGpsLoc)
    }

    override fun stopLoc() {
        AmapGpsLocation.instance.stopLoc()
    }

    override fun cleansLoc() {
        AmapGpsLocation.instance.cleansLoc()
    }

    override fun drivingPathPlanning(
        starPoint: MSLatLng,
        startName: String,
        endPoint: MSLatLng,
        endName: String,
        ways: List<WayPoi>,
        mapReadView: MapReadyView?,
        onDriveRoute: OnDriveRoute?
    ) {
        AmapRoutePlans.instance.drivingPathPlanning(
            starPoint,
            startName,
            endPoint,
            endName,
            ways,
            mapReadView,
            onDriveRoute
        )
    }

    override fun startNavi(
        mapReadView: MapReadyView?,
        navType: Int,
        starPoint: MSLatLng,
        startName: String,
        endPoint: MSLatLng,
        endName: String,
        ways: List<WayPoi>,
        onNaviPresenterListener:OnNaviPresenterListener?
    ) {
        if (navType == 1) {
//            throw NoSuchMethodException("高德导航暂不支持自己实现回调")
            AmapNai.startPlanNavi(starPoint, startName, endPoint, endName, ways)
        } else if (navType == 2) {
            AmapNai.startNavi(starPoint, startName, endPoint, endName, ways)
        }
    }

    companion object {
        val amapBasic: AmapBasic by lazy { AmapBasic() }
    }
}