package com.sd.api.factorys

import com.sd.api.bean.MSLatLng
import com.sd.api.bean.WayPoi
import com.sd.api.core.MapReadyView
import com.sd.api.core.basic.MSMarker
import com.sd.api.core.basic.MSOverlay
import com.sd.api.core.basic.OnDriveRoute
import com.sd.api.core.basic.OnMSPoiSearchLis
import com.sd.api.core.basic.OnMsGpsLoc
import com.sd.api.intfaces.OnNaviPresenterListener

/**接口实现抽象**/
abstract class AbsMapCore : IMapBasic, IMapBusin {

    /**基础接口实现抽象**/
    var iMapBasic = MapFactory.createBasic()

    /**业务接口实现抽象**/
    var iMapBusin = MapFactory.createBusin()

    //-------------------------基础接口实现抽象----------------------------------
    override fun toggleLayers(mapReadView: MapReadyView?, type: Int) {
        iMapBasic.toggleLayers(mapReadView, type)
    }

    override fun setLocationStyle(mapReadView: MapReadyView?, type: Int) {
        iMapBasic.setLocationStyle(mapReadView, type)
    }

    override fun setRotateGesturesEnabled(mapReadView: MapReadyView?, enable: Boolean) {
        iMapBasic.setRotateGesturesEnabled(mapReadView, enable)
    }

    override fun setTiltGesturesEnabled(mapReadView: MapReadyView?, enable: Boolean) {
        iMapBasic.setTiltGesturesEnabled(mapReadView, enable)
    }

    override fun setMapCenter(mapReadView: MapReadyView?, lat: Double, lng: Double) {
        iMapBasic.setMapCenter(mapReadView, lat, lng)
    }

    override fun setMapZoom(mapReadView: MapReadyView?, zoom: Float) {
        iMapBasic.setMapZoom(mapReadView, zoom)
    }

    override fun drawMarket(mapReadView: MapReadyView?, lat: Double, lng: Double): MSMarker {
        return iMapBasic.drawMarket(mapReadView, lat, lng)
    }


    override fun drawPolyline(
        mapReadView: MapReadyView?,
        msLatLng: List<MSLatLng>,
        width: Float,
        fcolor: Int,
        isDotted: Boolean
    ): MSOverlay {
        return iMapBasic.drawPolyline(mapReadView, msLatLng, width, fcolor, isDotted)
    }

    override fun drawCircle(
        mapReadView: MapReadyView?,
        lat: Double,
        lng: Double,
        radius: Float,
        fillColor: Int,
        strokeColor: Int,
        strokeWidth: Float
    ): MSOverlay {
        return iMapBasic.drawCircle(
            mapReadView,
            lat,
            lng,
            radius,
            fillColor,
            strokeColor,
            strokeWidth
        )
    }

    override fun drawPolygon(
        mapReadView: MapReadyView?,
        msLatLng: List<MSLatLng>,
        dLine: Boolean,
        fillColor: Int,
        strokeWidth: Float,
        strokeColor: Int
    ): MSOverlay {
        return iMapBasic.drawPolygon(
            mapReadView,
            msLatLng,
            dLine,
            fillColor,
            strokeWidth,
            strokeColor
        )
    }


    override fun startPoiSearch(
        keyWord: String,
        lat: Double,
        lng: Double,
        onMSPoiSearchLis: OnMSPoiSearchLis
    ) {
        iMapBasic.startPoiSearch(keyWord, lat, lng, onMSPoiSearchLis)
    }

    override fun startPoiSearchBound(
        keyWord: String,
        lat: Double,
        lng: Double,
        radios: Int,
        onMSPoiSearchLis: OnMSPoiSearchLis
    ) {
        iMapBasic.startPoiSearchBound(keyWord, lat, lng, radios, onMSPoiSearchLis)
    }


    override fun startLoc(onMsGpsLoc: OnMsGpsLoc) {
        iMapBasic.startLoc(onMsGpsLoc)
    }

    override fun stopLoc() {
        iMapBasic.stopLoc()
    }

    override fun cleansLoc() {
        iMapBasic.cleansLoc()
    }

    override fun drivingPathPlanning(
        starPoint: MSLatLng,
        startName: String,
        endPoint: MSLatLng,
        endName: String,
        ways: List<WayPoi>,
        mapReadView: MapReadyView?,
        onDriveRoute: OnDriveRoute?
    ) {
        iMapBasic.drivingPathPlanning(starPoint, startName, endPoint, endName, ways, mapReadView,onDriveRoute)
    }


    override fun startNavi(
        mapReadView: MapReadyView?,
        navType: Int,
        starPoint: MSLatLng,
        startName: String,
        endPoint: MSLatLng,
        endName: String,
        ways: List<WayPoi>,
        onNaviPresenterListener:OnNaviPresenterListener?
    ) {
        iMapBasic.startNavi(mapReadView, navType, starPoint, startName, endPoint, endName, ways,onNaviPresenterListener)
    }


    //-------------------------基础接口实现抽象----------------------------------

}