package com.sd.api.core.basic.mine

import android.graphics.Point
import android.graphics.Rect
import com.minedata.minenavi.map.Route
import com.minedata.minenavi.map.RouteOptions
import com.minedata.minenavi.mapdal.DataPreference
import com.minedata.minenavi.mapdal.LatLng
import com.minedata.minenavi.mapdal.PoiFavorite
import com.minedata.minenavi.navi.NaviSession
import com.minedata.minenavi.navi.RouteBase
import com.minedata.minenavi.navi.RouteCollection
import com.minedata.minenavi.navi.RoutePlan
import com.minedata.minenavi.navi.RouterErrorInfo
import com.minedata.minenavi.util.Tools
import com.sd.api.bean.DriverRouteBean
import com.sd.api.bean.MSLatLng
import com.sd.api.bean.WayPoi
import com.sd.api.core.MapReadyView
import com.sd.api.core.basic.OnDriveRoute
import com.sd.api.intfaces.MyMineNaviListener
import com.sd.api.utils.DisplayUtil


/**四维路劲规划*/
object MineRoutePlans {

    //初始化四维导航对象
    private var mNaviSession: NaviSession? = null

    //驾车算路回调对象
    private var driverRouteBean = DriverRouteBean.instance

    //驾车路径规划回调接口
    private var onDriveRoute: OnDriveRoute? = null

    /**
     * 路线图层
     */
    private var mRoute: Route? = null

    /**
     * 四维保存当前算好的路线
     */
    var mRouteBase: RouteBase? = null

    private var mapReadView: MapReadyView? = null

    /** 路径规划起点*/
    var mStartPoint: Point = Point()

    /**驾车路径规划
     * @param starPoint 起点坐标
     * @param startName 起点名称
     * @param endPoint 终点坐标
     * @param endName 终点名称（高德可不传）
     * @param ways     途经点集合
     * @param mapReadView 地图对象
     * @param onDriveRoute 路径规划结果回调
     */
    fun drivingPathPlanning(
        starPoint: MSLatLng,
        startName: String = "当前位置",
        endPoint: MSLatLng,
        endName: String = "",
        ways: List<WayPoi>,
        mapReadView: MapReadyView?,
        onDriveRoute: OnDriveRoute?
    ) {
        this.onDriveRoute = onDriveRoute
        this.mapReadView = mapReadView

//        var context = UserCtx.instance.mContext
        mNaviSession = NaviSession.getInstance()
        // 开启语音播报
        mNaviSession?.enableSound(true)
        /*        var naviSessionParams = NaviSessionParams().apply {
                    autoReroute = true
                    autoRemoveRoute = true
        //            useMineNaviGPS = true
                }
                mNaviSession!!.init(context, naviSessionParams)*/

        mNaviSession?.setDataPreference(DataPreference.preferOnline)
        mNaviSession?.addMineNaviListener(planiListener)

        mStartPoint = Tools.latLngToPoint(LatLng(starPoint.lat, starPoint.lng))
        val endPoint = Tools.latLngToPoint(LatLng(endPoint.lat, endPoint.lng))
        var startName = startName
        var endName = endName
        var wayPoints = mutableListOf<PoiFavorite>()
        if (ways.count() > 0) {
            ways.forEach { wpoi ->
                var passPoint =
                    Tools.latLngToPoint(LatLng(wpoi.passPoint!!.lat, wpoi.passPoint!!.lng))
                wayPoints.add(PoiFavorite(passPoint, wpoi.passName))
            }
        }
        val routePlan = RoutePlan()
        routePlan.setRoutePreference(RoutePlan.RoutePreference.none)
        routePlan.setTransportationType(RoutePlan.TransportationType.car)

        mNaviSession?.calculateDriveRoute(
            PoiFavorite(mStartPoint, startName),
            wayPoints,
            PoiFavorite(endPoint, endName),
            routePlan,
            NaviSession.RouteMethod.multipleResult
        )

    }


    /**
     * 绘制规划的路线路径。
     * @param routeBase 路线数据
     */
    fun drawPlanPath(routeBase: RouteBase?) {
        if (routeBase == null)
            return
        // 移除旧的路线覆盖物
        if (mRoute != null) {
            mapReadView?.mMineMap?.removeOverlay(mRoute)
            mRoute = null
        }

        val options = RouteOptions()
            .routeBase(routeBase)
            .colorType(Route.RouteColorType.enrouteTi)
            .styleClass("DEFAULT")

        // 添加新的路线到地图上，并设置样式和视角适配
        mRoute = mapReadView?.mMineMap?.addRoute(options)
        setRouteOverlayStyle(mRoute, false)
        navEndFitWorldAreaToRect(mapReadView, routeBase)
    }


    private fun setRouteOverlayStyle(route: Route?, isSmallMapRoute: Boolean = false) {
        var routeStyle = "DEFAULT"

        if (isSmallMapRoute) {
            routeStyle += ",small-map"
        }
        route?.selectStyleClass(routeStyle)
    }

    /**将指定的地图上的矩形区域显示到指定的屏幕矩形区域中
     * @param mRouteBase 路线数据
     */
    private fun navEndFitWorldAreaToRect(mapReadView: MapReadyView?, mRouteBase: RouteBase?) {
        if (mRouteBase == null)
            return
        val rect = Rect(
            200, 350, DisplayUtil.getScreenWidthPx() - 200,
            DisplayUtil.getScreenHeightPx() - 200
        )
        // 获取单条道路信息
        val boundingBox = mRouteBase.getBoundingBox()
        mapReadView?.mMineMap?.fitWorldAreaToRect(boundingBox, rect)
//                    mapReadView?.mMineMap?.setElevation(0f)
    }


//    /**自定义驾车路线返回*/
//    interface OnDriveRoute {
//        fun onDriverRoute(any: Any)
//    }


    //-------------- 四维 导航监听 --------------------------
    private var planiListener = object : MyMineNaviListener() {

        private fun getRouteMsg(data: RouterErrorInfo): String {
            var msg = ""
            when (data.errCode) {
                RouterErrorInfo.Type.ComputeFailed -> msg = "路线计算失败"
                RouterErrorInfo.Type.destAuthError -> msg = "终点所在位置数据授权错误"
                RouterErrorInfo.Type.destNoData -> msg = "重点所在位置没有数据"
                RouterErrorInfo.Type.MissingSubfiles -> msg = "缺少途径省份数据"
                RouterErrorInfo.Type.NetworkError -> msg = "网络连接错误"
                RouterErrorInfo.Type.None -> {}
                RouterErrorInfo.Type.NotEnoughMemory -> msg = "没有足够的内存可以使用"
                RouterErrorInfo.Type.oriAuthError -> msg = "起点所在位置数据授权错误"
                RouterErrorInfo.Type.OriDestTooNear -> msg = "起点和终点距离太近"
                RouterErrorInfo.Type.oriNoData -> msg = "起点所在位置没有数据"
                RouterErrorInfo.Type.SetDestFailed -> msg = "设置终点失败"
                RouterErrorInfo.Type.SetOriFailed -> msg = "设置起点失败"
                RouterErrorInfo.Type.waypointAuthError -> msg = "途经点所在位置数据授权错误"
                RouterErrorInfo.Type.waypointNoData -> msg = "途经点所在位置没有数据"
            }
            return msg
        }

        override fun onCalculateRouteSuccess(data: RouteCollection) {
            // 路线规划成功
            // 获取单条道路信息
            mRouteBase = data.routes.get(0)
            drawPlanPath(mRouteBase)
            driverRouteBean.routeBase = mRouteBase
            onDriveRoute?.onDriverRoute(driverRouteBean)
        }

        override fun onCalculateRouteFailed(data: RouterErrorInfo) {
            // 路线规划失败
            val msg = getRouteMsg(data)
            var a = 0
        }

    }


}