package com.sd.api.core.basic.mine

import android.graphics.BitmapFactory
import androidx.core.graphics.toColorInt
import com.minedata.minenavi.map.CircleOptions
import com.minedata.minenavi.map.MarkerOptions
import com.minedata.minenavi.map.PolygonOptions
import com.minedata.minenavi.map.PolylineOptions
import com.minedata.minenavi.mapdal.LatLng
import com.msmap.api.R
import com.sd.api.UserCtx
import com.sd.api.bean.MSLatLng
import com.sd.api.core.MapReadyView
import com.sd.api.core.basic.MSMarker
import com.sd.api.core.basic.MSOverlay


/**
 * 四维在地图上绘制
 */
object MineDrawInMap {


    /**
     * 绘制 marker 点
     * @param mapReadView 地图准备就绪的视图对象
     * @param lat 纬度坐标
     * @param lng 经度坐标
     * @return MSMarker 标记点对象
     */
    fun drawMarket(
        mapReadView: MapReadyView?,
        lat: Double,
        lng: Double
    ): MSMarker {
        var context = UserCtx.instance.mContext
        // 根据不同的地图类型绘制标记点
        val icon = BitmapFactory.decodeResource(context?.resources, R.drawable.market_loc)
        val latLng = LatLng(lat, lng)
        var options = MarkerOptions()
            .zLevel(7)
            .bitmap(icon)
            // 位置坐标
            .position(latLng)
        var maker = mapReadView?.mMineMap?.addMarker(options)
        MSMarker.maker = maker
        return MSMarker
    }


    /**
     * 绘制线
     * @param mapReadView 地图加载返回
     * @param msLatLng 坐标点集合
     * @param width 线宽度，默认为10f
     * @param fcolor 线颜色，默认为"#FF00FF"对应的int值
     * @param isDotted 是否为虚线，默认为false
     * @return MSOverlay 覆盖物对象
     */
    fun drawPolyline(
        mapReadView: MapReadyView?,
        msLatLng: List<MSLatLng>,
        width: Float = 10f,
        fcolor: Int = "#FF00FF".toColorInt(),
        isDotted: Boolean = false
    ): MSOverlay {
        // 绘制自定义地图的线
        var latLngs = msLatLng.map {
            LatLng(it.lat, it.lng)
        }
        var options = PolylineOptions()
            // 添加顶点坐标
            .addAll(latLngs)
            .width(width)
            .color(fcolor)
            .setDottedLine(isDotted)
        var polyline = mapReadView?.mMineMap?.addPolyline(options)
        MSOverlay.polyline = polyline
        return MSOverlay
    }


    /**绘制圆形
     * @param mapReadView 地图准备就绪视图对象
     * @param lat 维度
     * @param lng 经度
     * @param radius 半径（米）
     * @param fillColor 填充颜色，默认为半透明红色
     * @param strokeColor 边框颜色，默认为半透明蓝色
     * @param strokeWidth 边框宽度，默认为15f
     * @return MSOverlay 返回覆盖物对象
     */
    fun drawCircle(
        mapReadView: MapReadyView?,
        lat: Double,
        lng: Double,
        radius: Float,
        fillColor: Int = "#50FF0000".toColorInt(),
        strokeColor: Int = "#500000FF".toColorInt(),
        strokeWidth: Float = 15f
    ): MSOverlay {
        // 根据地图类型绘制不同类型的圆形
        var latLng = LatLng(lat, lng)
        val options = CircleOptions()
            .center(latLng)
            .radius(radius)
            .fillColor(fillColor)
            .strokeColor(strokeColor)
            .strokeWidth(strokeWidth)
        var circle = mapReadView?.mMineMap?.addCircle(options)
        MSOverlay.circle = circle
        return MSOverlay
    }


    /***
     * 绘制多边形
     * @param msLatLng   添加多边形顶点坐标集合
     * @param dLine 是否虚线
     * @param fillColor 填充颜色
     * @param strokeWidth 边框宽度
     * @param strokeColor 边框颜色
     * ****/
    fun drawPolygon(
        mapReadView: MapReadyView?,
        msLatLng: List<MSLatLng>,
        dLine: Boolean = false,
        fillColor: Int = "#10FF00FF".toColorInt(),
        strokeWidth: Float = 5f,
        strokeColor: Int = "#50FF00FF".toColorInt()
    ): MSOverlay {
        var latLngs = msLatLng.map {
            LatLng(it.lat, it.lng)
        }
        // 声明 多边形参数对象
        val polygonOptions = PolygonOptions().apply {
            addAll(latLngs)
            fillColor(fillColor)
            strokeWidth(strokeWidth)
            strokeColor(strokeColor)
            dottedLine(dLine)
        }
        var polygon = mapReadView?.mMineMap?.addPolygon(polygonOptions)
        MSOverlay.polygon = polygon
        return MSOverlay
    }

}