package com.sd.api.core.basic.amap

import com.amap.api.services.core.AMapException
import com.amap.api.services.poisearch.PoiSearch.SearchBound
import com.sd.api.UserCtx
import com.sd.api.bean.PoiSearchRes
import com.sd.api.core.basic.OnMSPoiSearchLis
import com.amap.api.services.core.LatLonPoint as ALatLonPoint
import com.amap.api.services.poisearch.PoiResult as APoiResult
import com.amap.api.services.poisearch.PoiSearch as APoiSearch

/**
 * 高配的Poi 搜索相关
 */
object AmapPoiSearch : APoiSearch.OnPoiSearchListener {


    private var onMSPoiSearchLis: OnMSPoiSearchLis? = null


    /**关键字搜索
     * @param keyWord 关键字
     * @param lat 当期维度
     * @param lng 当期经度
     * @param onMSPoiSearchLis 搜索回调
     */
    fun startPoiSearch(
        keyWord: String,
        lat: Double = 41.80196,
        lng: Double = 123.43326,
        onMSPoiSearchLis: OnMSPoiSearchLis
    ) {
        this.onMSPoiSearchLis = onMSPoiSearchLis
        var context = UserCtx.instance.mContext

        var query = APoiSearch.Query(keyWord, "", "").apply {
            location = ALatLonPoint(lat, lng)
            cityLimit = false
            // 返回父子关系
            requireSubPois(true)
            pageNum = 1
            pageSize = 20
        }
        var poiSearch = APoiSearch(context, query)
        poiSearch.setOnPoiSearchListener(this)
        poiSearch.searchPOIAsyn()

    }

    /**周边搜索
     * @param keyWord 关键字
     * @param lat 当前维度
     * @param lng 当前经度
     * @param radios 搜索半径(单位 米)
     * @param onMSPoiSearchLis 回调
     */
    fun startPoiSearchBound(
        keyWord: String,
        lat: Double,
        lng: Double,
        radios: Int,
        onMSPoiSearchLis: OnMSPoiSearchLis
    ) {
        this.onMSPoiSearchLis = onMSPoiSearchLis
        var context = UserCtx.instance.mContext


        var query = APoiSearch.Query(keyWord, "", "").apply {
            location = ALatLonPoint(lat, lng)
            cityLimit = true
            // 返回父子关系
            requireSubPois(true)
            pageNum = 1
            pageSize = 20
        }
        var poiSearch = APoiSearch(context, query)
        poiSearch.setOnPoiSearchListener(this)
        poiSearch.setBound(SearchBound(ALatLonPoint(lat, lng), radios, true))

        poiSearch.searchPOIAsyn()

    }


    //--------------------------------高德POI 搜索- -------------------------------

    override fun onPoiSearched(result: APoiResult?, rCode: Int) {
        if (rCode == AMapException.CODE_AMAP_SUCCESS) {
            if (result != null && result.getQuery() != null) {// 搜索poi的结果
                var temps = result?.getPois()
                var poiList = temps!!.map { pos ->
                    PoiSearchRes().apply {
                        lat = pos.latLonPoint.latitude
                        lng = pos.latLonPoint.longitude
                        title = pos.title
                        snippet = pos.snippet
                        cityName = pos.cityName
                        //这里为0 因为不是范围搜索
                        distance = pos.distance
                        adCode = pos.adCode
                    }
                }
                onMSPoiSearchLis?.onPoiLis(poiList)
            }
        } else {
            onMSPoiSearchLis?.onPoiLis(listOf())
        }
    }

    override fun onPoiItemSearched(p0: com.amap.api.services.core.PoiItem?, p1: Int) {
    }

}