package com.sd.api.core.basic.amap

import com.amap.api.maps.model.Poi
import com.amap.api.navi.AmapNaviPage
import com.amap.api.navi.AmapNaviParams
import com.amap.api.navi.AmapNaviType
import com.amap.api.navi.AmapPageType
import com.sd.api.UserCtx
import com.sd.api.bean.MSLatLng
import com.sd.api.bean.WayPoi
import com.amap.api.maps.model.LatLng as ALatLng


/**
 * 高德导航
 */
object AmapNai {

    /**
     * 直接开始导航
     *
     * @param starPoint
     * @param startName
     * @param endPoint
     * @param endName
     * @param ways
     */
    fun startNavi(
        starPoint: MSLatLng,
        startName: String,
        endPoint: MSLatLng,
        endName: String,
        ways: List<WayPoi>
    ) {
        var context = UserCtx.instance.mContext
        //途经点
        var poiList = mutableListOf<Poi>()
        if (ways.count() > 0) {
            ways.forEach { wpoi ->
                poiList.add(
                    Poi(
                        wpoi.passName,
                        ALatLng(wpoi.passPoint!!.lat, wpoi.passPoint!!.lng),
                        ""
                    )
                )
            }
        }
        val params = AmapNaviParams(
            Poi(startName, ALatLng(starPoint.lat, starPoint.lng), ""),
            poiList,
            Poi(endName, ALatLng(endPoint.lat, endPoint.lng), ""),
            AmapNaviType.DRIVER, AmapPageType.NAVI
        )
        params.setUseInnerVoice(true)
        AmapNaviPage.getInstance()
            .showRouteActivity(context, params, null)
    }


    /**
     * 展示路径规划
     *
     * @param starPoint
     * @param startName
     * @param endPoint
     * @param endName
     * @param ways
     */
    fun startPlanNavi(
        starPoint: MSLatLng,
        startName: String,
        endPoint: MSLatLng,
        endName: String,
        ways: List<WayPoi>
    ) {
        var context = UserCtx.instance.mContext
        //途经点
        var poiList = mutableListOf<Poi>()
        if (ways.count() > 0) {
            ways.forEach { wpoi ->
                poiList.add(
                    Poi(
                        wpoi.passName,
                        ALatLng(wpoi.passPoint!!.lat, wpoi.passPoint!!.lng),
                        ""
                    )
                )
            }
        }
        val params = AmapNaviParams(
            Poi(startName, ALatLng(starPoint.lat, starPoint.lng), ""),
            poiList,
            Poi(endName, ALatLng(endPoint.lat, endPoint.lng), ""),
            AmapNaviType.DRIVER, AmapPageType.ROUTE
        )
        params.setUseInnerVoice(true)
        AmapNaviPage.getInstance()
            .showRouteActivity(context, params, null)
    }


}