package com.sd.api.core.basic.amap

import com.sd.api.core.MapReadyView
import com.sd.api.core.basic.MSLocStyle
import com.amap.api.maps.model.MyLocationStyle as aMapMyLocationStyle


/**
 * 显示定位小圆点
 */
object AmapLocationStyle {


    // 高德定位类型
    private var styleAMap = mapOf(
        MSLocStyle.LOCATION_TYPE_LOCATE to aMapMyLocationStyle.LOCATION_TYPE_LOCATE,
        MSLocStyle.LOCATION_TYPE_FOLLOW to aMapMyLocationStyle.LOCATION_TYPE_FOLLOW,
        MSLocStyle.LOCATION_TYPE_MAP_ROTATE to aMapMyLocationStyle.LOCATION_TYPE_MAP_ROTATE,
        MSLocStyle.LOCATION_TYPE_LOCATION_ROTATE to aMapMyLocationStyle.LOCATION_TYPE_LOCATION_ROTATE,
        MSLocStyle.LOCATION_TYPE_LOCATION_ROTATE_NO_CENTER to aMapMyLocationStyle.LOCATION_TYPE_LOCATION_ROTATE_NO_CENTER,
        MSLocStyle.LOCATION_TYPE_FOLLOW_NO_CENTER to aMapMyLocationStyle.LOCATION_TYPE_FOLLOW_NO_CENTER,
        MSLocStyle.LOCATION_TYPE_MAP_ROTATE_NO_CENTER to aMapMyLocationStyle.LOCATION_TYPE_MAP_ROTATE_NO_CENTER
    )

    //高德初始化定位蓝点样式类
    private val aMyLocationStyle by lazy { aMapMyLocationStyle() }

    /**
     * 设置定位蓝点样式
     * @param mapReadView 地图准备就绪视图对象
     * @param type 定位类型，默认为LOCATION_TYPE_LOCATION_ROTATE，表示连续定位并旋转视角
     */
    fun setLocationStyle(mapReadView: MapReadyView?, type: Int =   MSLocStyle.LOCATION_TYPE_LOCATION_ROTATE) {
        var aMap = mapReadView?.aMap
        aMyLocationStyle.myLocationType(styleAMap.get(type)!!)
        aMyLocationStyle.interval(2000) //设置连续定位模式下的定位间隔，只在连续定位模式下生效，单次定位模式下不会生效。单位为毫秒。
//aMap.getUiSettings().setMyLocationButtonEnabled(true);设置默认定位按钮是否显示，非必需设置。
        aMap?.setMyLocationEnabled(true) // 设置为true表示启动显示定位蓝点，false表示隐藏定位蓝点并不进行定位，默认是false。
        aMap?.setMyLocationStyle(aMyLocationStyle)//设置定位蓝点的Style

    }


}