package com.sd.api.core.basic

/**
 * 定位蓝点常量
 */
object MSLocStyle {
    /**定位一次，且将视角移动到地图中心点**/
    const val LOCATION_TYPE_LOCATE: Int = 2

    /**连续定位、且将视角移动到地图中心点，定位蓝点跟随设备移动**/
    const val LOCATION_TYPE_FOLLOW: Int = 3

    /**连续定位、且将视角移动到地图中心点，地图依照设备方向旋转，定位点会跟随设备移动**/
    const val LOCATION_TYPE_MAP_ROTATE: Int = 4

    /**连续定位、且将视角移动到地图中心点，定位点依照设备方向旋转，并且会跟随设备移动**/
    const val LOCATION_TYPE_LOCATION_ROTATE: Int = 5

    /**连续定位、蓝点不会移动到地图中心点，定位点依照设备方向旋转，并且蓝点会跟随设备移动**/
    const val LOCATION_TYPE_LOCATION_ROTATE_NO_CENTER: Int = 6

    /**连续定位、蓝点不会移动到地图中心点，并且蓝点会跟随设备移动**/
    const val LOCATION_TYPE_FOLLOW_NO_CENTER: Int = 7

    /**连续定位、蓝点不会移动到地图中心点，地图依照设备方向旋转，并且蓝点会跟随设备移动**/
    const val LOCATION_TYPE_MAP_ROTATE_NO_CENTER: Int = 8
}