package com.sd.demo.ui

import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import com.sd.api.bean.RegeocodeRes
import com.sd.api.core.basic.MSRegeoCode
import com.sd.demo.databinding.ActivityTreGeocodeBinding


/***逆地理编码***/
class TReGeocodeActivity : AppCompatActivity() {

    private lateinit var binding: ActivityTreGeocodeBinding

//    var mapReadView: MapReadyView? = null


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityTreGeocodeBinding.inflate(layoutInflater)
        setContentView(binding.root)
//        binding.mapMultiView.addMapRenderCallback(object : OnMapReadyLis {
//            override fun onMapReady(mapReadyView: MapReadyView) {
//                this@TReGeocodeActivity.mapReadView = mapReadyView
//            }
//        })
        binding.bt.setOnClickListener {
            var lat = binding.et2.text.toString().toDouble()
            var lng = binding.et1.text.toString().toDouble()
            //逆地理编码
            MSRegeoCode.geoCoder(lat, lng, object : MSRegeoCode.MSOnRegeo {
                override fun onRegeo(regeocodeRes: RegeocodeRes?) {
                    var sb = StringBuilder()
                    sb.append(regeocodeRes?.province+" ")
                    sb.append(regeocodeRes?.city+"  ")
                    sb.append("城市编码:${regeocodeRes?.cityCode}  ")
                    sb.append(regeocodeRes?.town)
                    binding.tv.setText(sb)
                }
            })
        }
    }



}