package com.sd.demo.ui

import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import com.sd.api.bean.MSLatLng
import com.sd.api.core.MapReadyView
import com.sd.api.core.basic.MSDrawInMap
import com.sd.api.core.basic.MSOverlay
import com.sd.api.factorys.MapCoreApi
import com.sd.api.ui.MapMultiView.OnMapReadyLis
import com.sd.demo.databinding.ActivityTpolygonBinding

/**绘制一个面***/
class TPolygonActivity : AppCompatActivity() {

    private lateinit var binding: ActivityTpolygonBinding

    var mapReadView: MapReadyView? = null
    //覆盖物对象
    private var mSOverlay: MSOverlay? = null
    //获取接口功能实例
    var mapCoreApi = MapCoreApi.mapCoreApi

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityTpolygonBinding.inflate(layoutInflater)
        setContentView(binding.root)

        binding.mapMultiView.addMapRenderCallback(object : OnMapReadyLis {
            override fun onMapReady(mapReadyView: MapReadyView) {
                this@TPolygonActivity.mapReadView = mapReadyView

//                MSMethodAdv.setMapZoom(mapReadView, 9f)

                //绘制一个面
                var mspLatLng = listOf<MSLatLng>(
                    MSLatLng(39.993391, 116.135272), MSLatLng(39.808323, 116.057604),
                    MSLatLng(39.904430, 116.265061), MSLatLng(39.950192, 116.140002)
                )
                mSOverlay = mapCoreApi.drawPolygon(mapReadView, mspLatLng,true)
            }
        })

        //删除面
        binding.bt1.setOnClickListener {
            //删除面
            MSDrawInMap.deletePolygon(mapReadView, mSOverlay)
        }

    }


}