package com.sd.demo.ui

import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import com.sd.api.bean.PoiSearchRes
import com.sd.api.core.MapReadyView
import com.sd.api.core.basic.OnMSPoiSearchLis
import com.sd.api.factorys.MapCoreApi
import com.sd.api.ui.MapMultiView.OnMapReadyLis
import com.sd.demo.adapter.PoiAdapter
import com.sd.demo.databinding.ActivityTpoiSearchBinding

/****poi关键字搜索，范围搜索**/
class TPoiSearchActivity : AppCompatActivity() {

    private lateinit var binding: ActivityTpoiSearchBinding

    var mapReadView: MapReadyView? = null

    //POI返回列表适配器
    private var poiAdapter = PoiAdapter()

    //获取接口功能实例
    var mapCoreApi = MapCoreApi.mapCoreApi

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityTpoiSearchBinding.inflate(layoutInflater)
        setContentView(binding.root)

        binding.mapMultiView.addMapRenderCallback(object : OnMapReadyLis {
            override fun onMapReady(mapReadyView: MapReadyView) {
                this@TPoiSearchActivity.mapReadView = mapReadyView
                //绘制Marker点 116.3985,39.9079
//                MSCanvesInMap.dMarket(this@TLineActivity, mapReadView, 39.907900, 116.398500)
//                MSMethodAdv.setMapCenter(mapReadView, 39.999391, 116.135972)
            }
        })

        binding.poiList.adapter = poiAdapter

        //关键字检索
        binding.bt.setOnClickListener {
            poiAdapter.submitList(listOf())
            var str = binding.et.text.toString()
            testPoiSearch(str)
        }

        //范围搜索
        binding.bt2.setOnClickListener {
            poiAdapter.submitList(listOf())
            var str = binding.et.text.toString()
            testPoiSearchBound(str)
        }

    }


    //poi搜索
    fun testPoiSearch(keyword: String) {
        //poi搜索
        mapCoreApi.startPoiSearch(
            keyword,//关键字
            41.80196,
            123.43326,
            object : OnMSPoiSearchLis {
                override fun onPoiLis(
                    poiList: List<PoiSearchRes>
                ) {
                    //自定义适配器展示列表
                    poiAdapter.submitList(poiList)
                }
            })
    }

    //poi 范围搜索
    fun testPoiSearchBound(keyword: String) {
        //poi 范围搜索
        mapCoreApi.startPoiSearchBound(
            keyword,
            39.977290,
            116.337000,
            binding.et1.text.toString().toInt(),//检索范围单位米
            object : OnMSPoiSearchLis {
                override fun onPoiLis(
                    poiList: List<PoiSearchRes>
                ) {
                    poiAdapter.submitList(poiList)
                }
            })
    }


}