package com.sd.demo.ui

import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import com.sd.api.core.MapReadyView
import com.sd.api.core.basic.MSDrawInMap
import com.sd.api.core.basic.MSMarker
import com.sd.api.factorys.MapCoreApi
import com.sd.api.ui.MapMultiView.OnMapReadyLis
import com.sd.demo.databinding.ActivityTmarkerBinding

/***绘制Marker点***/
class TMarkerActivity : AppCompatActivity() {

    private lateinit var binding: ActivityTmarkerBinding

    var mapReadView: MapReadyView? = null

    //marker点实例
    var msMark: MSMarker? = null


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityTmarkerBinding.inflate(layoutInflater)
        setContentView(binding.root)

        //获取接口功能实例
        var mapCoreApi = MapCoreApi.mapCoreApi

        binding.mapMultiView.addMapRenderCallback(object : OnMapReadyLis {
            override fun onMapReady(mapReadyView: MapReadyView) {
                this@TMarkerActivity.mapReadView = mapReadyView
                //绘制Marker点 116.3985,39.9079
                msMark = mapCoreApi.drawMarket(mapReadView, 39.907900, 116.398500)
//                MSMethodAdv.setMapCenter(mapReadView, 39.977290, 116.337000)
            }
        })

        binding.bt1.setOnClickListener {
            //删除Marker点
            MSDrawInMap.deleteMarker(mapReadView, msMark)
        }


    }


}