package com.sd.demo.ui

import android.graphics.Color
import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import com.sd.api.bean.MSLatLng
import com.sd.api.core.MapReadyView
import com.sd.api.core.basic.MSDrawInMap
import com.sd.api.core.basic.MSOverlay
import com.sd.api.factorys.MapCoreApi
import com.sd.api.ui.MapMultiView.OnMapReadyLis
import com.sd.demo.databinding.ActivityTlineBinding

/*****绘制一条线**/
class TLineActivity : AppCompatActivity() {

    private lateinit var binding: ActivityTlineBinding

    var mapReadView: MapReadyView? = null

    //覆盖物对象
    private var mSOverlay: MSOverlay? = null
    //虚线对象
    private var mSOverlay2: MSOverlay? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityTlineBinding.inflate(layoutInflater)
        setContentView(binding.root)

        //获取接口功能实例
        var mapCoreApi = MapCoreApi.mapCoreApi

        binding.mapMultiView.addMapRenderCallback(object : OnMapReadyLis {
            override fun onMapReady(mapReadyView: MapReadyView) {
                this@TLineActivity.mapReadView = mapReadyView
                //绘制Marker点 116.3985,39.9079
                mapCoreApi.drawMarket( mapReadView, 39.907900, 116.398500)
                mapCoreApi.setMapCenter(mapReadView, 39.999391, 116.135972)
            }
        })

        binding.bt1.setOnClickListener {
            //绘制一条线   //画实线
            var msLatLng = listOf<MSLatLng>(
                MSLatLng(39.999391, 116.135972), MSLatLng(39.898323, 116.057694),
                MSLatLng(39.900430, 116.265061), MSLatLng(39.955192, 116.140092)
            )
            mSOverlay =
                mapCoreApi.drawPolyline(mapReadView, msLatLng, 5f, Color.argb(255, 255, 0, 255))
        }
        binding.bt2.setOnClickListener {
            //画虚线
            var msLatLng = listOf<MSLatLng>(
                MSLatLng(39.999591, 116.135973), MSLatLng(39.898123, 116.057691),
                MSLatLng(39.900230, 116.265062), MSLatLng(39.951192, 116.140090)
            )
            mSOverlay2 = mapCoreApi.drawPolyline(
                mapReadView,
                msLatLng,
                5f,
                Color.argb(0, 255, 0, 255),
                isDotted = true
            )
        }
        //删除线
        binding.bt3.setOnClickListener {
            //删除实线
            MSDrawInMap.deletePolyline(mapReadView,mSOverlay)
            //删除虚线
            MSDrawInMap.deletePolyline(mapReadView,mSOverlay2)
        }


    }


}