package com.sd.demo.ui

import android.os.Bundle
import androidx.activity.enableEdgeToEdge
import androidx.appcompat.app.AppCompatActivity
import com.sd.api.core.MapReadyView
import com.sd.api.factorys.MapCoreApi
import com.sd.api.ui.MapMultiView.OnMapReadyLis
import com.sd.demo.databinding.ActivityHighMapBinding

/**
 * T high map activity
 *
 * @constructor Create empty T high map activity
 */
class THighMapActivity : AppCompatActivity() {

    private lateinit var binding: ActivityHighMapBinding

    var mapReadView: MapReadyView? = null

    //获取接口功能实例
    var mapCoreApi = MapCoreApi.mapCoreApi

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        enableEdgeToEdge()
        binding = ActivityHighMapBinding.inflate(layoutInflater)
        setContentView(binding.root)
//        ViewCompat.setOnApplyWindowInsetsListener(findViewById(R.id.main)) { v, insets ->
//            val systemBars = insets.getInsets(WindowInsetsCompat.Type.systemBars())
//            v.setPadding(systemBars.left, systemBars.top, systemBars.right, systemBars.bottom)
//            insets
//        }

        binding.mapMultiView.addMapRenderCallback(object : OnMapReadyLis {
            override fun onMapReady(mapReadyView: MapReadyView) {
                this@THighMapActivity.mapReadView = mapReadyView
            }
        })

    }
}