package com.sd.demo.ui

//import com.sd.maplibrary.core.MSRoutePlans
//import com.sd.maplibrary.core.MSRoutePlans.OnDriveRoute
import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import com.minedata.minenavi.navi.GuidanceText
import com.minedata.minenavi.navi.NaviProgressData
import com.minedata.minenavi.navi.SmoothNaviData
import com.minedata.minenavi.navi.TmcSections
import com.sd.api.bean.MSLatLng
import com.sd.api.bean.WayPoi
import com.sd.api.core.MapReadyView
import com.sd.api.factorys.MapCoreApi
import com.sd.api.intfaces.OnNaviPresenterListener
import com.sd.api.ui.MapMultiView.OnMapReadyLis
import com.sd.demo.databinding.ActivityTdriveRouteBinding


/***驾车路径规划***/
class TDriveRouteActivity : AppCompatActivity() ,OnNaviPresenterListener{

    private lateinit var binding: ActivityTdriveRouteBinding

    var mapReadView: MapReadyView? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityTdriveRouteBinding.inflate(layoutInflater)
        setContentView(binding.root)

        binding.mapMultiView.addMapRenderCallback(object : OnMapReadyLis {
            override fun onMapReady(mapReadyView: MapReadyView) {
                this@TDriveRouteActivity.mapReadView = mapReadyView
            }
        })

        //开始路径规划
        binding.starplan.setOnClickListener {
            if (mapReadView == null) return@setOnClickListener
            // 起点坐标 116.3215,39.8919
            val startPoint = MSLatLng(39.806898, 116.490682)
            // 终点坐标116.3793,39.8643
            val endPoint = MSLatLng(39.864311, 116.379311)
            // 终点名称
            val endName = "沈阳火车站"
            var wayPoi = WayPoi(
                passName = "鸟巢", passPoint = MSLatLng(39.99300, 116.39524)
            )
            var ways = listOf<WayPoi>(wayPoi)

            //获取接口功能实例
            var mapCoreApi = MapCoreApi.mapCoreApi
            //开始路径规划
            mapCoreApi.drivingPathPlanning(
                startPoint, "当前位置", endPoint, endName, ways, mapReadView,null
            )
//            MSRoutePlans.drivingPathPlanning(startPoint, endPoint, ways, endName)

//            testDriverPlan()
//            testDriverPlanaMAP()
        }

        //直接开始导航
        binding.starnai.setOnClickListener {
            if (mapReadView == null) return@setOnClickListener
            //获取接口功能实例
            var mapCoreApi = MapCoreApi.mapCoreApi

            // 起点坐标 116.3215,39.8919
            val startPoint = MSLatLng(39.806898, 116.490682)
             // 终点坐标116.3793,39.8643
            val endPoint = MSLatLng(39.864311, 116.379311)
            // 终点名称
            val endName = "沈阳火车站"
            //途经点
            var wayPoi = WayPoi(
                passName = "鸟巢", passPoint = MSLatLng(39.99300, 116.39524)
            )
            var ways = listOf<WayPoi>(wayPoi)

            mapCoreApi.startNavi(mapReadView, 2/*1=自己实现回调 2=直接调用导航组件*/, startPoint, "当前位置", endPoint, endName, ways,this)
        }

    }


 /*   参考DEMO https://gitee.com/cennavi_sy/MineNaviDemo.git
    中的 app/src/main/java/com/cennavi/minenavidemo/activity/navi/NaviActivity.java
    和 app/src/main/java/com/cennavi/minenavidemo/presenter/NaviPresenter.java*/

    //车位置发生改变
    override fun onTracking(ratio: Float) {
    }

    //导航或者模拟导航时平滑跟踪
    override fun onSmoothTracking(data: SmoothNaviData) {
    }

    //解析 naviProgressData 导航更新信息
    override fun onDataUpdated(naviProgressData: NaviProgressData) {
    }

    //解析 tmcSections 路况(TMC) 信息条中的段信息
    override fun onTiBarUpdated(tmcSections: TmcSections) {
    }

    //解析 guidanceText 引导文字信息
    override fun onTextChanged(guidanceText: GuidanceText) {
    }

    //导航路口剩余距离
    override fun onDistanceChanged(distance: Int) {
    }

    //导航路口剩余距离 目前是没有下一个引导点，距离路线距离10米，即为到达目的地。 有下一个引导点，下一个引导距此引导点距离在10米以内，到此引导距离在3米以内，也为到达目的地
    override fun onArriveDestination() {
    }

    //导航结束
    override fun onNaviEnded() {
    }

    //算路结果回调
    /*    private var onDriveRoute = object : OnDriveRoute {
            override fun onDriverRoute(driverRouteBean: DriverRouteBean) {
                MSRoutePlans.drawPlanPath(
                    mapReadView,
                    driverRouteBean
                )
            }
        }*/


}