package com.sd.demo.ui

import android.os.Bundle
import androidx.activity.viewModels
import androidx.appcompat.app.AppCompatActivity
import com.sd.api.core.MapReadyView
import com.sd.api.factorys.MapCoreApi
import com.sd.api.ui.MapMultiView.OnMapReadyLis
import com.sd.demo.databinding.ActivityShowMyLocLandianBinding
import com.sd.demo.viewmodels.MapDemoVm

/***显示定位蓝点***/
class ShowMyLocLandian : AppCompatActivity() {

    val mapDempVm: MapDemoVm by viewModels()

    private lateinit var binding: ActivityShowMyLocLandianBinding

    var mapReadView: MapReadyView? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        binding = ActivityShowMyLocLandianBinding.inflate(layoutInflater)
        setContentView(binding.root)

        //获取接口功能实例
        var mapCoreApi = MapCoreApi.mapCoreApi

        binding.mapMultiView.addMapRenderCallback(object : OnMapReadyLis {
            override fun onMapReady(mapReadyView: MapReadyView) {
                this@ShowMyLocLandian.mapReadView=mapReadyView
                mapCoreApi.setLocationStyle(this@ShowMyLocLandian.mapReadView)
            }
        })

    }


}