package com.sd.demo.ui

import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import com.sd.api.core.MapReadyView
import com.sd.api.factorys.MapCoreApi
import com.sd.api.ui.MapMultiView.OnMapReadyLis
import com.sd.demo.databinding.ActivityGestureDemoBinding

/****手势控制***/
class GestureDemo : AppCompatActivity() {


    private lateinit var binding: ActivityGestureDemoBinding

    var mapReadView: MapReadyView? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        binding = ActivityGestureDemoBinding.inflate(layoutInflater)
        setContentView(binding.root)

        binding.mapMultiView.addMapRenderCallback(object : OnMapReadyLis {
            override fun onMapReady(mapReadyView: MapReadyView) {
                this@GestureDemo.mapReadView = mapReadyView
            }
        })

        //获取接口功能实例
        var mapCoreApi = MapCoreApi.mapCoreApi

        binding.bt1.setOnClickListener {
            //关闭（打开）旋转
            mapCoreApi.setRotateGesturesEnabled(mapReadView, false)
        }
        binding.bt2.setOnClickListener {
            //关闭（打开）倾斜开关
            mapCoreApi.setTiltGesturesEnabled(mapReadView, false)
        }


    }


}