package com.sd.api.scenario

import com.example.car_and_road_3d.models.Alarm
import com.sd.api.highmap.HighMap
import com.sd.api.highmap.WarnPtc
import com.sd.api.parkroad.MsParkRoad
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch

/**预警管理类***/
object V2xWarn {

    //高精地图预警对象
    private var warnPtcs = mutableListOf<WarnPtc>()

    //局部地图预警对象
    private var alarms = mutableListOf<Alarm>()

    /**
     * 感知物预警(批量)
     */
    fun setWarningBatch(ptcIds: List<String>, time: Int = 0, dirent: Int = 0) {
        startWarning(ptcIds, time, dirent)
    }

    /**
     * 感知物预警(单个)
     * @param ptcId 感知物ID列表
     * @param time 感知物闪烁时间 0=不闪烁
     * @param dirent 雷达方向0=关闭  1=左前 2=正前 3=右前   4=右后  5=正后  6=左后
     */
    fun setWarning(ptcId: String, time: Int = 0, dirent: Int = 0) {
        startWarning(listOf(ptcId), time, dirent)
    }

    /***停止预警***/
    fun stopWarning() {
        warnPtcs.forEach {
            it.isRed = false
            it.isFlash = false
            it.aniTime = 0L
        }
        alarms.forEach {
            it.isAlarm = false
            it.time = 0
        }
        HighMap.setWarnPtc(warnPtcs)
        MsParkRoad.warnAlerms(alarms)
    }

    private fun startWarning(ptcId: List<String>, time: Int, dirent: Int) {
        warnPtcs.clear()
        alarms.clear()
        ptcId.forEach { ptcId ->
            //构造高精地体预警类
            warnPtcs.add(WarnPtc().apply {
                this.ptcid = ptcId
                this.isRed = true
                if (time > 0) {
                    this.aniTime = time.toLong()
                    this.isFlash = true
                }
            })
            //构造局部地图预警类
            alarms.add(Alarm().apply {
                this.participantId = ptcId
                this.isAlarm = false
                if (time > 0) {
                    this.isAlarm = true
                    this.time = time
                }
            })
        }
        //高精图预警
        HighMap.setWarnPtc(warnPtcs)

        CoroutineScope(Dispatchers.Main).launch {
            HighMap.setCarRadarDirection(dirent)
            HighMap.setCarBottomCircle(true)
            delay(5000)
            HighMap.setCarBottomCircle(false)
            HighMap.setCarRadarDirection(0)
        }
        //局部图预警
        MsParkRoad.warnAlerms(alarms)
        CoroutineScope(Dispatchers.Main).launch {
            MsParkRoad.toggleRadar(true)
            delay(5000)
            MsParkRoad.toggleRadar(false)
        }
    }

    /**
     * 设置局部图预警点
     * @param marker 1:结冰 2:施工 3:交叉路口慢行
     * */
    fun setWarnMark(mark: Int) {
        MsParkRoad.showMarker(mark)
    }

}