package com.sd.api.scenario

import com.sd.api.MAP_TYPE
import com.sd.api.MSDKInitializer
import com.sd.api.highmap.HighMap
import com.sd.api.highmap.UnityPtc
import com.sd.api.parkroad.MsParkRoad
import com.sd.api.parkroad.PtcBean
import com.sd.api.scenario.bean.Percept

/***感知物管理**/
object PerceptionManager {

    /**更新感知物位置
     * @param percepts 感知物列表
     * @param upSoap(更新范围)  1:更新局部图感知物 2:更新高精图感知物 3：包含两者
     */
    fun upPerception(percepts: List<Percept>, upSoap: Int) {
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                if (upSoap == 1) {
                    refreshParkPerception(percepts)
                } else if (upSoap == 2) {
                    refreshHighPerception(percepts)
                } else if (upSoap == 3) {
                    refreshParkPerception(percepts)
                    refreshHighPerception(percepts)
                }
            }

            MAP_TYPE.AMAP -> {
            }
        }
    }

    //刷新局部图感知物
    private fun refreshParkPerception(percepts: List<Percept>) {
        //转化sdk可用的感知物
        var pres = percepts.map { it ->
            PtcBean().apply {
                ptcId = it.ptcid
                ptcType = it.pType
                lat = it.lat
                lng = it.lon
                heading = it.heading
            }
        }
        MsParkRoad.upDatePreTarget(pres)
    }

    //刷新高精图感知物
    private fun refreshHighPerception(percepts: List<Percept>) {
        var pres = percepts.map { it ->
            UnityPtc().apply {
                ptcid = it.ptcid
                pType = it.pType
                lat = it.lat
                lon = it.lon
                heading = it.heading
            }
        }
        HighMap.setPtcData(pres)
    }

    /***清除所有感知物**/
    fun clearAllPerception() {
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                MsParkRoad.clearAllTargets()
                HighMap.setPtcData(emptyList())
            }

            MAP_TYPE.AMAP -> {
            }
        }
    }


}