package com.sd.api.maps.mine

import android.graphics.BitmapFactory
import androidx.core.graphics.toColorInt
import com.minedata.minenavi.map.CircleOptions
import com.minedata.minenavi.map.MarkerOptions
import com.minedata.minenavi.map.PolygonOptions
import com.minedata.minenavi.map.PolylineOptions
import com.minedata.minenavi.mapdal.LatLng
import com.sd.api.R
import com.sd.api.UserCtx
import com.sd.api.maps.MsCircleOptions
import com.sd.api.maps.MsPolygonOptions
import com.sd.api.maps.MsPolylineOptions
import com.sd.api.maps.cdata.MSLatLng
import com.sd.api.maps.cdata.MSMarker
import com.sd.api.maps.cdata.MSOverlay
import com.sd.api.ui.MapReadyView

/**
 * 四维在地图上绘制
 */
internal object MineDrawInMap {


    /**
     * 绘制 marker 点
     * @param mapReadView 地图准备就绪的视图对象
     * @param lat 纬度坐标
     * @param lng 经度坐标
     * @return MSMarker 标记点对象
     */
    fun drawMarket(
        mapReadView: MapReadyView?,
        lat: Double,
        lng: Double
    ): MSMarker {
        var context = UserCtx.Companion.instance.mContext
        // 根据不同的地图类型绘制标记点
        val icon = BitmapFactory.decodeResource(context?.resources, R.drawable.market_loc)
        val latLng = LatLng(lat, lng)
        var options = MarkerOptions()
            .bitmap(icon)
            // 位置坐标
            .position(latLng)
        var maker = mapReadView?.mMineMap?.addMarker(options)
        MSMarker.maker = maker
        return MSMarker
    }


    /**
     * 绘制线
     * @param mapReadView 地图加载返回
     * @param msLatLng 坐标点集合
     * @param msPolylineOptions 绘制线选项
     */
    fun drawPolyline(
        mapReadView: MapReadyView?,
        msLatLng: List<MSLatLng>,
        msPolylineOptions:MsPolylineOptions
    ): MSOverlay {
        // 绘制自定义地图的线
        var latLngs = msLatLng.map {
            LatLng(it.lat, it.lng)
        }
        var options = PolylineOptions()
            // 添加顶点坐标
            .addAll(latLngs)
            .width(msPolylineOptions.width)
            .color(msPolylineOptions.fcolor)
            .outlineColor(msPolylineOptions.outlineColor)
            .setDottedLine(msPolylineOptions.isDotted)
        var polyline = mapReadView?.mMineMap?.addPolyline(options)
        MSOverlay.polyline = polyline
        return MSOverlay
    }


    /**绘制圆形
     * @param mapReadView 地图准备就绪视图对象
     * @param center 中心点坐标
     * @param msCircleOptions 绘制圆形选项
     * @return MSOverlay 返回覆盖物对象
     */
    fun drawCircle(
        mapReadView: MapReadyView?,
        center: MSLatLng,
        msCircleOptions:MsCircleOptions?
    ): MSOverlay {
        // 根据地图类型绘制不同类型的圆形
        var latLng = LatLng(center.lat, center.lng)
        val options = CircleOptions()
            .center(latLng)
            .radius(msCircleOptions?.radius?:100f)
            .fillColor(msCircleOptions?.fillColor?:"#50FF0000".toColorInt())
            .strokeColor(msCircleOptions?.strokeColor?:"#500000FF".toColorInt())
            .strokeWidth(msCircleOptions?.strokeWidth?:15f)
        var circle = mapReadView?.mMineMap?.addCircle(options)
        MSOverlay.circle = circle
        return MSOverlay
    }


    /**
     * 绘制多边形
     * @param msLatLng   添加多边形顶点坐标集合
     * @param msPolygonOptions 多边形绘制选型
     */
    fun drawPolygon(
        mapReadView: MapReadyView?,
        msLatLng: List<MSLatLng>,
        msPolygonOptions:MsPolygonOptions
    ): MSOverlay {
        var latLngs = msLatLng.map {
            LatLng(it.lat, it.lng)
        }
        // 声明 多边形参数对象
        val polygonOptions = PolygonOptions().apply {
            addAll(latLngs)
            fillColor(msPolygonOptions.fillColor)
            strokeWidth(msPolygonOptions.strokeWidth)
            strokeColor(msPolygonOptions.strokeColor)
            dottedLine(msPolygonOptions.dLine)
        }
        var polygon = mapReadView?.mMineMap?.addPolygon(polygonOptions)
        MSOverlay.polygon = polygon
        return MSOverlay
    }

}