package com.sd.api.maps.amap

import com.amap.api.maps.model.LatLng
import com.amap.api.maps.model.Poi
import com.amap.api.navi.AmapNaviPage
import com.amap.api.navi.AmapNaviParams
import com.amap.api.navi.AmapNaviType
import com.amap.api.navi.AmapPageType
import com.sd.api.UserCtx
import com.sd.api.bean.WayPoi
import com.sd.api.maps.cdata.MSLatLng

/**
 * 高德导航
 */
object AmapNai {

    /**
     * 直接开始导航
     *
     * @param starPoint
     * @param startName
     * @param endPoint
     * @param endName
     * @param ways
     */
    fun startNavi(
        starPoint: MSLatLng,
        startName: String,
        endPoint: MSLatLng,
        endName: String,
        ways: List<WayPoi>
    ) {
        var context = UserCtx.Companion.instance.mContext
        //途经点
        var poiList = mutableListOf<Poi>()
        if (ways.count() > 0) {
            ways.forEach { wpoi ->
                poiList.add(
                    Poi(
                        wpoi.passName,
                        LatLng(wpoi.passPoint!!.lat, wpoi.passPoint!!.lng),
                        ""
                    )
                )
            }
        }
        val params = AmapNaviParams(
            Poi(startName, LatLng(starPoint.lat, starPoint.lng), ""),
            poiList,
            Poi(endName, LatLng(endPoint.lat, endPoint.lng), ""),
            AmapNaviType.DRIVER, AmapPageType.NAVI
        )
        params.setUseInnerVoice(true)
        AmapNaviPage.getInstance()
            .showRouteActivity(context, params, null)
    }


    /**
     * 展示路径规划
     *
     * @param starPoint
     * @param startName
     * @param endPoint
     * @param endName
     * @param ways
     */
    fun startPlanNavi(
        starPoint: MSLatLng,
        startName: String,
        endPoint: MSLatLng,
        endName: String,
        ways: List<WayPoi>
    ) {
        var context = UserCtx.Companion.instance.mContext
        //途经点
        var poiList = mutableListOf<Poi>()
        if (ways.count() > 0) {
            ways.forEach { wpoi ->
                poiList.add(
                    Poi(
                        wpoi.passName,
                        LatLng(wpoi.passPoint!!.lat, wpoi.passPoint!!.lng),
                        ""
                    )
                )
            }
        }
        val params = AmapNaviParams(
            Poi(startName, LatLng(starPoint.lat, starPoint.lng), ""),
            poiList,
            Poi(endName, LatLng(endPoint.lat, endPoint.lng), ""),
            AmapNaviType.DRIVER, AmapPageType.ROUTE
        )
        params.setUseInnerVoice(true)
        AmapNaviPage.getInstance()
            .showRouteActivity(context, params, null)
    }


}