package com.sd.api.maps.amap

import com.amap.api.location.AMapLocation
import com.amap.api.location.AMapLocationClient
import com.amap.api.location.AMapLocationClientOption
import com.amap.api.location.AMapLocationListener
import com.sd.api.UserCtx
import com.sd.api.location.MSLocCb
import com.sd.api.location.OnMsGpsLoc

/**GPS定位类*/
class AmapGpsLocation {

    companion object {
        val instance: AmapGpsLocation by lazy { AmapGpsLocation() }
    }


    // 设置高德定位参数
    private val locationOption: AMapLocationClientOption by lazy {
        val mOption = AMapLocationClientOption()
        mOption.setLocationMode(AMapLocationClientOption.AMapLocationMode.Hight_Accuracy);//可选，设置定位模式，可选的模式有高精度、仅设备、仅网络。默认为高精度模式
        mOption.setGpsFirst(false);//可选，设置是否gps优先，只在高精度模式下有效。默认关闭
        mOption.setHttpTimeOut(30000);//可选，设置网络请求超时时间。默认为30秒。在仅设备模式下无效
        mOption.setInterval(2000);//可选，设置定位间隔。默认为2秒
        mOption.setNeedAddress(true);//可选，设置是否返回逆地理地址信息。默认是true
        mOption.setOnceLocation(false);//可选，设置是否单次定位。默认是false
        mOption.setOnceLocationLatest(false);//可选，设置是否等待wifi刷新，默认为false.如果设置为true,会自动变为单次定位，持续定位时不要使用
        AMapLocationClientOption.setLocationProtocol(AMapLocationClientOption.AMapLocationProtocol.HTTP);//可选， 设置网络请求的协议。可选HTTP或者HTTPS。默认为HTTP
        mOption.setSensorEnable(false);//可选，设置是否使用传感器。默认是false
        mOption.setWifiScan(true); //可选，设置是否开启wifi扫描。默认为true，如果设置为false会同时停止主动刷新，停止以后完全依赖于系统刷新，定位位置可能存在误差
        mOption.setLocationCacheEnable(true); //可选，设置是否使用缓存定位，默认为true
        mOption.setGeoLanguage(AMapLocationClientOption.GeoLanguage.DEFAULT);//可选，设置逆地理信息的语言，默认值为默认语言（根据所在地区选择语言）
        return@lazy mOption
    }

    // 高德定位实例
    private var alocationClient: AMapLocationClient? = null

    /**业务层Gps定位回调**/
    private var onMsGpsLoc: OnMsGpsLoc? = null

    /**初始化定位*/
    private fun initLoc() {
        var context = UserCtx.Companion.instance.mContext

        alocationClient = AMapLocationClient(context)
        //设置定位参数
        alocationClient!!.setLocationOption(locationOption)
        // 设置定位监听
        alocationClient!!.setLocationListener(locationListener)
    }


    /**开启定位*/
    fun starLoc(onMsGpsLoc: OnMsGpsLoc) {
        initLoc()
// 此方法为每隔固定时间会发起一次定位请求，为了减少电量消耗或网络流量消耗，
// 注意设置合适的定位时间的间隔（最小间隔支持为1000ms），并且在合适时间调用stopLocation()方法来取消定位请求
// 在定位结束后，在合适的生命周期调用onDestroy()方法
// 在单次定位情况下，定位无论成功与否，都无需调用stopLocation()方法移除请求，定位sdk内部会移除
//启动定位
        alocationClient?.startLocation()
    }

    /**停止定位*/
    fun stopLoc() {
//        alocationClient?.unRegisterLocationListener(locationListener)
        alocationClient?.stopLocation()
    }

    /**清理定位资源**/
    fun cleansLoc() {
        alocationClient?.onDestroy()
    }

    //-------高德回调------
    var locationListener: AMapLocationListener = object : AMapLocationListener {
        override fun onLocationChanged(location: AMapLocation?) {
            if (null != location) {
//                val sb = StringBuffer()
                //errCode等于0代表定位成功，其他的为定位失败，具体的可以参照官网定位错误码说明
                if (location.getErrorCode() == 0) {
//                    println("-------高德定位改变 = ${location?.latitude}   curLng=${location?.longitude}  speed=${location?.speed}")
                    var loc = MSLocCb.instance.apply {
                        lat = location?.latitude ?: 0.0
                        lng = location?.longitude ?: 0.0
                        speed = location?.speed ?: 0f
                        bearing = location?.bearing ?: 0f
                        accuracy = location?.accuracy ?: 0f
                        altitude = location?.altitude ?: 0.0
                    }
                    onMsGpsLoc?.onMsGpsLoc(loc)
                }
            } else {

            }
        }
    }


}