package com.sd.api.maps.amap

import com.sd.api.ui.MapReadyView

/**
 * 高德手势交互
 */
internal object AmapGestures {

//
//    /***缩放**/
//    fun setZoomGesturesEnabled(mapReadView: MapReadyView,enable: Boolean) {
//        when (MSDKInitializer.getMapType()) {
//            MAP_TYPE.MINE -> {
//                mapReadView.fMapView?.zoomView.is
//            }
//
//            MAP_TYPE.AMAP -> {
//                mapReadView.amap?.uiSettings?.setZoomGesturesEnabled(enable)
//            }
//        }
//    }


    /**
     * 设置地图旋转手势是否可用
     * @param mapReadView 地图准备就绪视图对象
     * @param enable 是否启用旋转手势功能
     */
    fun setRotateGesturesEnabled(mapReadView: MapReadyView?, enable: Boolean) {
        // 根据不同的地图类型设置对应的旋转手势可用状态
        mapReadView?.aMap?.uiSettings?.isRotateGesturesEnabled = enable
    }


    /**
     * 设置地图倾斜手势功能的启用状态
     * @param mapReadView 地图准备就绪视图对象
     * @param enable 是否启用倾斜手势功能，true为启用，false为禁用
     * */
    fun setTiltGesturesEnabled(mapReadView: MapReadyView?, enable: Boolean) {
        // 根据不同的地图类型设置对应的倾斜手势功能
        mapReadView?.aMap?.uiSettings?.isTiltGesturesEnabled = enable
    }


}