package com.sd.api.maps

import com.sd.api.MAP_TYPE
import com.sd.api.MSDKInitializer
import com.sd.api.bean.DriverRouteBean
import com.sd.api.bean.WayPoi
import com.sd.api.intfaces.OnNaviPresenterListener
import com.sd.api.maps.amap.AmapNai
import com.sd.api.maps.cdata.MSLatLng
import com.sd.api.maps.mine.MineNai
import com.sd.api.ui.MapReadyView

/**
 * 导航相关
 */
object MSNavi {
    /**是否开启导航**/
    var isStartNai = false

    fun init() {
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                MineNai.init()
            }

            MAP_TYPE.AMAP -> {
//                AmapNai.init()
            }
        }
    }

    /**
     * 开始导航
     * @param nType 1=自己实现回调 2=直接调用导航组件
     * @param starPoint  起点坐标
     * @param startName  起点名称
     * @param endPoint
     * @param endName
     * @param ways   途经点列表
     */
    fun startNavi(
        mapReadView: MapReadyView?,
        nType: Int,
        starPoint: MSLatLng,
        startName: String,
        endPoint: MSLatLng,
        endName: String,
        ways: List<WayPoi>,
        onNaviPresenterListener: OnNaviPresenterListener?
    ) {
        isStartNai = true
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                if (nType == 1) {
                    MineNai.startNavi(mapReadView, onNaviPresenterListener)
                } else if (nType == 2) {
                    MineNai.startNaviDirect(starPoint, startName, endPoint, endName, ways)
                }
            }

            MAP_TYPE.AMAP -> {
                if (nType == 1) {
                    AmapNai.startPlanNavi(starPoint, startName, endPoint, endName, ways)
                } else if (nType == 2) {
                    AmapNai.startNavi(starPoint, startName, endPoint, endName, ways)
                }
            }
        }
    }

    /**结束导航(模拟导航)**/
    fun endNavi() {
        isStartNai = false
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                MineNai.stopNavi()
            }

            MAP_TYPE.AMAP -> {

            }
        }
    }


    fun startSimNavi(
        mapReadView: MapReadyView?,
        starPoint: MSLatLng,
        driverRouteBean: DriverRouteBean?,
        onNaviPresenterListener: OnNaviPresenterListener?
    ) {
        isStartNai = true
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                MineNai.startSimNavi(
                    mapReadView,
                    starPoint,
                    driverRouteBean?.routeBase,
                    onNaviPresenterListener
                )
            }

            MAP_TYPE.AMAP -> {

            }
        }
    }

    fun addNaviListener(listener: OnNaviPresenterListener) {
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                MineNai.addNaviListener(listener)
            }

            MAP_TYPE.AMAP -> {

            }
        }
    }

}