package com.sd.api.fragments

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.fragment.app.Fragment
import androidx.fragment.app.activityViewModels
import com.example.car_and_road_3d.CarAndRoadWebViewClient
import com.minedata.minenavi.map.MineMap
import com.sd.api.databinding.FragmentForeMapBinding
import com.sd.api.databinding.FragmentPartRoadBinding
import com.sd.api.parkroad.MsParkRoad
import com.sd.api.ui.MapReadyView
import com.sd.api.ui.MapMultiView.OnMapReadyLis
import com.sd.api.vms.CarRoadVM
import kotlin.getValue

// the fragment initialization parameters, e.g. ARG_ITEM_NUMBER
//private const val ARG_PARAM1 = "param1"
//private const val ARG_PARAM2 = "param2"

/**
 *四维局部容器
 */
class PartRoadFragment : Fragment() {

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View {
        binding = FragmentPartRoadBinding.inflate(inflater, container, false)
        // Inflate the layout for this fragment
        return binding.root
    }

    private lateinit var binding: FragmentPartRoadBinding
    //局部图控制类
    private val carRoadVM: CarRoadVM by activityViewModels()

    private var onMapReadyLis: OnMapReadyLis? = null

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        initView()
        setLis()
    }

    private fun initView() {
        carRoadVM.webViewClient = CarAndRoadWebViewClient(binding.roadWebview)
        carRoadVM.webViewClient?.run {
            setDebugLogging(true)
            setWebViewLogging(true)
        }
//        carRoadVM.webViewClient?.preloadMainCar(requireActivity().assets.open("truck.glb")) { v: Boolean ->
//            println("-----------v = ${v}")
//        }
        //初始化局部视图控制器
        MapReadyView.instance.carRoadVM = carRoadVM
        MsParkRoad.setCarRoadVM(MapReadyView.instance)
        onMapReadyLis?.onMapReady(MapReadyView.instance)
    }

    private fun setLis() {

    }

    /**地图加载完成监听回调*/
    fun addMapRenderCallback(onMapReadyLis: OnMapReadyLis) {
        this.onMapReadyLis = onMapReadyLis
    }

    companion object {
        @JvmStatic
        fun newInstance() = PartRoadFragment()
    }


}