package com.sd.demo.ui

import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import com.minedata.minenavi.SDKInitializer
import com.minedata.minenavi.SDKInitializer.InitListener
import com.minedata.minenavi.map.MineMap
import com.sd.api.maps.MethodAdv
import com.sd.api.maps.WmsLayer
import com.sd.api.ui.MapMultiView.OnMapReadyLis
import com.sd.api.ui.MapReadyView
import com.sd.demo.databinding.ActivityWmtsBinding

/****
 * 加载wms
 */
class WmsActivity : AppCompatActivity() {

//    override fun onPause() {
//        super.onPause()
//        binding.mapView.onPause()
//    }
//
//    override fun onResume() {
//        super.onResume()
//        binding.mapView.onResume()
//    }
//
//    override fun onDestroy() {
//        super.onDestroy()
//        binding.mapView.onDestroy()
//    }

    lateinit var binding: ActivityWmtsBinding

    var mapReadView: MapReadyView? = null

    var url = "http://192.168.60.73:9999/tiles/{z}/{x}/{y}.png?layer=yizhuang:yizhuang_avp"
    var aMapurl = "http://192.168.59.216:8080/smartmap/wms?layers=yizhuang:yizhuang_avp"

    //    var url = "http://192.168.59.216:8080/smartmap/gwc/demo/yizhuang_avp?gridSet=EPSG:4326&format=image/png"
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityWmtsBinding.inflate(layoutInflater)
        setContentView(binding.root)

        binding.mapMultiView.addMapRenderCallback(object : OnMapReadyLis {
            override fun onMapReady(mapReadyView: MapReadyView) {
                this@WmsActivity.mapReadView = mapReadyView
//                SDKInitializer.setStyleUrl(MineMap.UrlType.satellite, url)
                WmsLayer.loadWmsLayer(aMapurl)
                //改变地图中心点
                MethodAdv.setMapCenter(39.80913878, 116.50166926)
            }
        })
        binding.bt2.setOnClickListener {
            //删除wms图层
            WmsLayer.removeWmsLayer()
        }
    }

    fun initMap() {
        var url = "http://192.168.60.73:9999/tiles/{z}/{x}/{y}.png?layer=yizhuang:yizhuang_avp"
        SDKInitializer.debug(false)
        // 隐私合规接口
        SDKInitializer.setAgreePrivacy(true)
        SDKInitializer.setStyleUrl(MineMap.UrlType.satellite, url)
        SDKInitializer.initialize(this, object : InitListener {
            override fun onInitSuccess() {
//                println("---Map onInitSuccess")
                setUpMap()
            }

            override fun onInitFailed(msg: String?) {
            }
        })
    }
    private fun setUpMap() {
//        binding.mapView.addMapRenderCallback(object : MapView.OnMapReadyListener {
//            override fun onMapReady(mineMap: MineMap?) {
//
//                mineMap?.setZoomLevel(14f)
//                //设置中心点
//                val point = Tools.latLngToPoint(LatLng(39.80913878, 116.50166926))
//                mineMap?.setPointToCenter(point.x, point.y)
//            }
//        })
    }



}