package com.sd.demo.ui

import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import com.sd.api.location.MSLocCb
import com.sd.api.location.MSLocation
import com.sd.api.location.OnMsGpsLoc
import com.sd.api.maps.DrawInMap
import com.sd.api.maps.MethodAdv
import com.sd.api.maps.cdata.MSMarker
import com.sd.api.ui.MapMultiView.OnMapReadyLis
import com.sd.api.ui.MapReadyView
import com.sd.demo.databinding.ActivityTgpsBinding

/***定位 ，展示我的位置***/
class TGpsActivity : AppCompatActivity() {

    private lateinit var binding: ActivityTgpsBinding

    var mapReadView: MapReadyView? = null

    var msMark: MSMarker? = null
    var lat = 0.0
    var lng = 0.0

    //获取接口功能实例
//    var mapCoreApi = MapCoreApi.mapCoreApi

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityTgpsBinding.inflate(layoutInflater)
        setContentView(binding.root)

        binding.mapMultiView.addMapRenderCallback(object : OnMapReadyLis {
            override fun onMapReady(mapReadyView: MapReadyView) {
                this@TGpsActivity.mapReadView = mapReadyView

                //绘制Marker点 116.3985,39.9079
//                MSCanvesInMap.dMarket(this@TLineActivity, mapReadView, 39.907900, 116.398500)
//                MSMethodAdv.setMapCenter(mapReadView, 39.999391, 116.135972)
            }
        })

        //开启定位
        MSLocation.startLoc(object : OnMsGpsLoc {
            override fun onMsGpsLoc(mSLocBean: MSLocCb) {
                println("---------mSLocBean = ${mSLocBean}")
                lat = mSLocBean.lat
                lng = mSLocBean.lng
                var sb = StringBuilder()
                sb.run {
                    append("纬度：${mSLocBean.lat} \n")
                    append("精度：${mSLocBean.lng} \n")
                    append("速度：${mSLocBean.speed} \n")
                    append("航向角:${mSLocBean.bearing} \n")
                    append("精度:${mSLocBean.accuracy} \n")
                    append("高程:${mSLocBean.altitude} \n")
                }
                binding.tv.text = sb
            }
        })

        //我的位置
        binding.bt1.setOnClickListener {
            msMark = DrawInMap.drawMarket(lat, lng)
            MethodAdv.setMapCenter(lat, lng)
        }
    }

    override fun onStop() {
        super.onStop()
        //停止定位
        MSLocation.stopLoc()
    }


    override fun onDestroy() {
        super.onDestroy()
        //清理资源
        MSLocation.cleansLoc()
    }

}