/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.idst.nui;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public final class DateUtil {
    public static final String DEFAULT_DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DEFAULT_FORMAT_DATE = "yyyy-MM-dd";
    public static final String DEFAULT_FORMAT_TIME = "HH:mm:ss";
    public static final ThreadLocal<SimpleDateFormat> defaultDateTimeFormat = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat(DateUtil.DEFAULT_DATE_TIME_FORMAT);
        }
    };
    public static final ThreadLocal<SimpleDateFormat> defaultDateFormat = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat(DateUtil.DEFAULT_FORMAT_DATE);
        }
    };
    public static final ThreadLocal<SimpleDateFormat> defaultTimeFormat = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat(DateUtil.DEFAULT_FORMAT_TIME);
        }
    };

    private DateUtil() {
        throw new RuntimeException("\uffe3 3\uffe3");
    }

    public static String getDateTimeFromMillis(long l2) {
        return DateUtil.getDateTimeFormat(new Date(l2));
    }

    public static String getDateFromMillis(long l2) {
        return DateUtil.getDateFormat(new Date(l2));
    }

    public static String getDateTimeFormat(Date date) {
        return DateUtil.dateSimpleFormat(date, defaultDateTimeFormat.get());
    }

    public static String getDateFormat(int n2, int n3, int n4) {
        return DateUtil.getDateFormat(DateUtil.getDate(n2, n3, n4));
    }

    public static String getDateFormat(Date date) {
        return DateUtil.dateSimpleFormat(date, defaultDateFormat.get());
    }

    public static String getTimeFormat(Date date) {
        return DateUtil.dateSimpleFormat(date, defaultTimeFormat.get());
    }

    public static String dateFormat(String string2, String object) {
        object = new SimpleDateFormat((String)object);
        return DateUtil.dateSimpleFormat(java.sql.Date.valueOf(string2), (SimpleDateFormat)object);
    }

    public static String dateFormat(Date date, String object) {
        object = new SimpleDateFormat((String)object);
        return DateUtil.dateSimpleFormat(date, (SimpleDateFormat)object);
    }

    public static String dateSimpleFormat(Date date, SimpleDateFormat simpleDateFormat) {
        if (simpleDateFormat == null) {
            simpleDateFormat = defaultDateTimeFormat.get();
        }
        if (date == null) {
            return "";
        }
        return simpleDateFormat.format(date);
    }

    public static Date getDateByDateTimeFormat(String string2) {
        return DateUtil.getDateByFormat(string2, defaultDateTimeFormat.get());
    }

    public static Date getDateByDateFormat(String string2) {
        return DateUtil.getDateByFormat(string2, defaultDateFormat.get());
    }

    public static Date getDateByFormat(String string2, String string3) {
        return DateUtil.getDateByFormat(string2, new SimpleDateFormat(string3));
    }

    private static Date getDateByFormat(String string2, SimpleDateFormat simpleDateFormat) {
        if (simpleDateFormat == null) {
            simpleDateFormat = defaultDateTimeFormat.get();
        }
        try {
            return simpleDateFormat.parse(string2);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            return null;
        }
    }

    public static Date getDate(int n2, int n3, int n4) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(n2, n3 - 1, n4);
        return calendar.getTime();
    }

    public static long getIntervalDays(String string2, String string3) {
        return (java.sql.Date.valueOf(string3).getTime() - java.sql.Date.valueOf(string2).getTime()) / 86400000L;
    }

    public static int getCurrentYear() {
        return Calendar.getInstance().get(1);
    }

    public static int getCurrentMonth() {
        return Calendar.getInstance().get(2) + 1;
    }

    public static int getDayOfMonth() {
        return Calendar.getInstance().get(5);
    }

    public static String getToday() {
        return DateUtil.getDateFormat(Calendar.getInstance().getTime());
    }

    public static String getYesterday() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        return DateUtil.getDateFormat(calendar.getTime());
    }

    public static String getBeforeYesterday() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -2);
        return DateUtil.getDateFormat(calendar.getTime());
    }

    public static String getOtherDay(int n2) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, n2);
        return DateUtil.getDateFormat(calendar.getTime());
    }

    public static String getCalcDateFormat(String string2, int n2) {
        return DateUtil.getDateFormat(DateUtil.getCalcDate(DateUtil.getDateByDateFormat(string2), n2));
    }

    public static Date getCalcDate(Date date, int n2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, n2);
        return calendar.getTime();
    }

    public static Date getCalcTime(Date date, int n2, int n3, int n4) {
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        calendar.add(11, n2);
        calendar.add(12, n3);
        calendar.add(13, n4);
        return calendar.getTime();
    }

    public static Date getDate(int n2, int n3, int n4, int n5, int n6, int n7) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(n2, n3, n4, n5, n6, n7);
        return calendar.getTime();
    }

    public static int[] getYearMonthAndDayFrom(String string2) {
        return DateUtil.getYearMonthAndDayFromDate(DateUtil.getDateByDateFormat(string2));
    }

    public static int[] getYearMonthAndDayFromDate(Date object) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime((Date)object);
        int[] nArray = new int[3];
        object = nArray;
        nArray[0] = calendar.get(1);
        object[1] = calendar.get(2);
        object[2] = calendar.get(5);
        return object;
    }
}

