package com.sd.api.vms

import androidx.lifecycle.ViewModel
import com.example.car_and_road_3d.CarAndRoadWebViewClient
import com.example.car_and_road_3d.models.InitRoadRequest
import com.example.car_and_road_3d.models.MainCar
import com.example.car_and_road_3d.models.Position
import com.sd.api.parkroad.RoadPos
import com.sd.api.parkroad.OnPrAddCar

//局部图控制类
class CarRoadVM : ViewModel() {
    //四维局部图
    var webViewClient: CarAndRoadWebViewClient? = null

    //主车是否首次添加
    private var isCarAdd = false

    //感知物是否首次添加
    private var isPtcAdd = false
    /**主车起点，用于传给路网计算*/
    private var startLoc: RoadPos? = null

    private var onPrAddCar:OnPrAddCar?=null

    /**
     * 更新主车位置
     * @param myloc 当前位置
     * @param onPrAddCar 主车是否添加成功回调，其他操作基于此
     */
    fun updateMainCar(myloc: RoadPos, onPrAddCar:OnPrAddCar?) {
        if (startLoc == null || startLoc?.lat == 0.0) {
            setStarLoc(myloc)
            return
        }
        //传入前2个不一样的点初始化
        var initRequest = InitRoadRequest(
            startLoc!!.lat, startLoc!!.lng,
            myloc.lat, myloc.lng
        )
        webViewClient?.initCarAndRoad(initRequest) { v: Boolean ->
//            var mainCar = MainCar(Position(myloc.lat,myloc.lng), myloc.bearing.toDouble())
            var mainCar = MainCar(Position(myloc.lat, myloc.lng), myloc.bearing.toDouble())
            if (!isCarAdd) {
                isCarAdd = true
                webViewClient?.addMainCar(mainCar) { v: Boolean ->
//                    println("--------addMainCar = ${v}")
                    onPrAddCar?.onPrAddCar(v)
//                    webViewClient?.showWalkLine(true) { }
//                    webViewClient?.showEarlyMarker(EarlyMarker.DEFAULT) { }
                }
            } else {
//                viewModelScope.launch {
                    webViewClient?.updateMainCar(mainCar) {}
                    setStarLoc(myloc)
//                }
            }
        }
    }

    private fun setStarLoc(myloc: RoadPos) {
        if (startLoc == null) {
            startLoc = RoadPos()
        }
        startLoc!!.run {
            this.lat = myloc.lat
            this.lng = myloc.lng
            this.bearing = myloc.bearing
//            this.altitude = myloc.altitude
        }
    }


    /**添加底部光圈*/
    fun showWarningCircle(circle: Boolean) {
        webViewClient?.showWarningCircle(circle) {}
    }

    /**设置感知物显示距离(米)*/
    fun setDistanceVisible(distance: Double) {
        webViewClient?.setDistanceVisible(distance) {}
    }

    /**跟车视角
     * @param camera 0、25、45、75、90度
     * */
    fun setCameraPosition(camera: Double) {
        webViewClient?.setCameraPosition(camera) {}
    }

    /**显示人行道*/
    fun showWalkLine(showWalk: Boolean){
        webViewClient?.showWalkLine(showWalk) { }
    }

//                    webViewClient?.showEarlyMarker(EarlyMarker.DEFAULT) { }

}