package com.sd.api.ui.widget

import android.content.Context
import android.util.AttributeSet
import androidx.appcompat.widget.AppCompatImageView
import com.minedata.minenavi.navi.RouteDetailItem
import com.minedata.minenavi.navi.TurnIconModel
import com.sd.api.R

class MyTurnIconView : AppCompatImageView {

    constructor(context: Context) : super(context)
    constructor(context: Context, attrs: AttributeSet?) : super(context, attrs)
    constructor(context: Context, attrs: AttributeSet?, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    )

    fun setTurnIconModel(turnIconModel: TurnIconModel) {
        when (turnIconModel.toDirection) {
            4 -> {//左转
                setImageResource(R.drawable.turn_left)
            }

            in 5..7 -> {//左前
                setImageResource(R.drawable.turn_left_font)
            }

            12 -> {//右转
                setImageResource(R.drawable.turn_right)
            }

            in 9..11 -> {//右前
                setImageResource(R.drawable.turn_right_font)
            }

            in 1..2 -> {//左后
                setImageResource(R.drawable.turn_left_back)
            }
        }
    }

    fun setTurnIconId(turnIconId: Int) {
        when (turnIconId) {
            TurnIconModel.TurnIconId.keepDrivingOnCurrentRoad -> {
                //沿路直行
                setImageResource(R.drawable.turn_zhixing)
            }

            TurnIconModel.TurnIconId.turnAround -> {
                //掉头
                setImageResource(R.drawable.turn_diaotou)
            }

            TurnIconModel.TurnIconId.enterRotary, TurnIconModel.TurnIconId.leaveRotary, TurnIconModel.TurnIconId.uTurnOnRotary -> {
                //环岛
                setImageResource(R.drawable.turn_rota)
            }

            TurnIconModel.TurnIconId.straightKeepLeft -> {
                //左侧直行
                setImageResource(R.drawable.turn_left_ver)
            }

            TurnIconModel.TurnIconId.straightKeepRight -> {
                //右侧直行
                setImageResource(R.drawable.turn_right_ver)
            }

            RouteDetailItem.TurnIconID.WindOverpass -> {
                //盘桥立交桥
                setImageResource(R.drawable.turn_38)
            }

            RouteDetailItem.TurnIconID.Overpass -> {
                //非盘桥立交桥
                setImageResource(R.drawable.turn_37)
            }
        }

    }
}