package com.sd.api.ui

import android.content.Context
import android.graphics.Rect
import android.util.AttributeSet
import com.minedata.minenavi.map.MapView
import com.minedata.minenavi.map.MineMap
import com.minedata.minenavi.map.TrafficEventInfo
import com.minedata.minenavi.mapdal.InitializationException
import javax.microedition.khronos.egl.EGLConfig
import javax.microedition.khronos.opengles.GL10

/**四维在线地图容器**/
class ForeMapView : MapView {

    constructor(context: Context?) : super(context)
    constructor(context: Context?, attrs: AttributeSet?) : super(context, attrs)

    interface Listener {
        fun onCameraChanged(changeType: Int)

        fun onTrafficEventIconClicked(type: Int, trafficEventInfo: TrafficEventInfo?)

        fun onScrollStarted()

        fun onScrollFinished()
    }

    private val mListeners = arrayListOf<Listener>()

    fun addListener(listener: Listener) {
        mListeners.add(listener)
    }

    override fun onSurfaceCreated(gl10: GL10?, eglConfig: EGLConfig?) {
        super.onSurfaceCreated(gl10, eglConfig)
    }

    override fun onSurfaceChanged(gl: GL10?, width: Int, height: Int) {
        super.onSurfaceChanged(gl, width, height)
    }

    override fun onCameraChanged(changeType: Int) {
        super.onCameraChanged(changeType)

        for (listener in mListeners) {
            listener.onCameraChanged(changeType)
        }
    }

    override fun onTrafficEventIconClicked(type: Int, trafficEventInfo: TrafficEventInfo?) {
        super.onTrafficEventIconClicked(type, trafficEventInfo)

        for (listener in mListeners) {
            listener.onTrafficEventIconClicked(type, trafficEventInfo)
        }
    }

    override fun onScrollStarted() {
        super.onScrollStarted()
        for (listener in mListeners) {
            listener.onScrollStarted()
        }
    }

    override fun onScrollFinished(isScroll: Boolean) {
        super.onScrollFinished(isScroll)

        for (listener in mListeners) {
            listener.onScrollFinished()
        }
    }


    override fun createMineMap(rct: Rect?, listener: MineMap.Listener?): MineMap? {
        try {
            return MineMap(context, listener, true)
        } catch (e: InitializationException) {
            e.printStackTrace()
        }
        return null
    }



}