package com.sd.api.scenario

import android.util.Log
import androidx.lifecycle.viewModelScope
import com.minedata.minenavi.map.Model
import com.minedata.minenavi.map.ModelOptions
import com.minedata.minenavi.map.Overlay
import com.minedata.minenavi.mapdal.LatLng
import com.sd.api.MAP_TYPE
import com.sd.api.MSDKInitializer
import com.sd.api.UserCtx
import com.sd.api.maps.MsOperationParent
import com.sd.api.utils.FileIoUtils
import com.unity3d.player.UnityPlayer
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch
import java.io.File
import java.io.IOException

/**网联车模型**/
object VehicleModel : MsOperationParent() {

    //在线地图用户当前位置模型
    private var mainCarMo: Model? = null

    //主车obj模型
    private var objPath = ""

    //在线地图小车是否加载完毕
    private var loadAddCar = false

    /****加载主车特斯拉模型***/
    suspend  fun loadMainCar() {
        var context = UserCtx.instance.mContext
//        CoroutineScope(Dispatchers.IO).launch {
            try {
                var parentFileDir = File(context?.filesDir, "models/car_model")
                if (!parentFileDir.exists())
                    parentFileDir.mkdirs()

                objPath = FileIoUtils.assetFilePath(context!!, "models/car_model/gszh_xyz.obj")
//                Log.d("-----", "✅ OBJ文件复制成功: " + objPath)
                var path = FileIoUtils.assetFilePath(context, "models/car_model/gszh_xyz.mtl")
//                Log.d("-----", "✅ 纹理文件复制成功: " + path)
                path = FileIoUtils.assetFilePath(context, "models/car_model/Binary_0.jpeg")
//                Log.d("-----", "✅ 材质文件复制成功: " + path)
            } catch (e: IOException) {
                e.printStackTrace()
            }
//        }
    }

    /****更新模型位置**/
    fun upMyLocCarModel(
        lat: Double,
        lng: Double,
        heading: Float
    ) {
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                CoroutineScope(Dispatchers.Default).launch {
                    loadMainCar()
                    if (!loadAddCar) {
                        loadAddCar= true
                        addMyLocCarModel(lat, lng, heading)
                    }
                    var cHeading = 0f - 180f - heading
                    mainCarMo?.setPosition(LatLng(lat, lng))
                    mainCarMo?.setHeading(cHeading)
                }
            }

            MAP_TYPE.AMAP -> {
            }
        }
    }


    /****添加我的定位小车模型
     * 这小车模型航向角0是冲下的
     * ***/
    suspend fun addMyLocCarModel(
        lat: Double,
        lng: Double,
        heading: Float
    ) {
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                if (objPath.isEmpty() || lat == 0.0 || lng == 0.0)
                    return
                if (mainCarMo != null)
                    return
                var mMineMap = getMapReadView()?.mMineMap
                // 模型文件相对路径
                var modelOptions = ModelOptions()
                    .objFile(objPath)
                    .position(LatLng(lat, lng))
                    .layer(Overlay.Layer.aboveMarker)
                    .heading(heading)
                    .keepScaleSize(8f) // 保持尺寸的比例尺
                    .scaleFactor(0.007f) // 缩放因子
                    .visible(true)

                mainCarMo = mMineMap?.addModel(modelOptions)
            }

            MAP_TYPE.AMAP -> {
            }
        }
    }

    //删除互联网地图上的车模型
    fun deleteMyLocModel() {
        if (mainCarMo != null) {
            var mMineMap = getMapReadView()?.mMineMap
            mMineMap?.removeOverlay(mainCarMo)
            mainCarMo = null
        }
    }

}