package com.sd.api.scenario

import androidx.lifecycle.viewModelScope
import com.minedata.minenavi.mapdal.LatLng
import com.sd.api.highmap.CarNavPath
import com.sd.api.highmap.HighMap
import com.sd.api.highmap.HighPos
import com.sd.api.parkroad.MsParkRoad
import com.sd.api.parkroad.RoadPos
import com.sd.api.utils.SmoothMoveUtils
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch

/**车辆管理类***/
object CucsVehicle {

    private var stopCar = false

    //动画是否开始
    private var isAniStart = false

    //前一次位置
    private var fromLoc: VehiclePos? = null

    //当前位置
    private var cvPos: VehiclePos? = null

    //保存上一次位置的时间
    private var oldTime = 0L

    //2次定位的时间差，默认1000毫秒
    private var vehTimeDiff = 1000L

    /**
     * 移动车辆
     * @param vPos 车辆位置
     * @param moveType 1=高精地图 2= 局部地图 3=在线地图
     */
    fun moveCar(vPos: VehiclePos, moveType: Int) {
        cvPos = vPos
        var highPos = HighPos.instance.apply {
            heading = vPos.heading
            lat = vPos.lat
            lon = vPos.lng
            evel = vPos.evel
        }
        var roadPos = RoadPos.instance.apply {
            lat = vPos.lat
            lng = vPos.lng
            bearing = vPos.heading.toFloat()
        }

        if (moveType == 1) {
            HighMap.setCarPosition(highPos)
        } else if (moveType == 2) {
            MsParkRoad.updateMainCar(roadPos, null)
        } else if (moveType == 3) {
            if (fromLoc == null || fromLoc?.lng == 0.0) {
                setFromMyLoc(vPos)//设置起始位置
            }
            //计算2次定位时间差
            calTimeDiff()
            if (isAniStart == false) {
                isAniStart = true
                SmoothMoveUtils.startSmoothMove(
                    LatLng(fromLoc!!.lat, fromLoc!!.lng),
                    LatLng(vPos.lat, vPos.lng),
                    vehTimeDiff,
                    sCarSmooth
                )
            }
        }
    }

    //在线地图主车平滑移动
    private var sCarSmooth = object : SmoothMoveUtils.OnPositionUpdateListener {
        override fun onUpdate(
            iLatLng: LatLng,
            bearing: Float
        ) {
            //在线地图主车平滑移动
            VehicleModel.upMyLocCarModel(
                iLatLng.latitude,
                iLatLng.longitude,
                cvPos?.heading?.toFloat() ?: 0f
            )
        }

        override fun onFinish() {
//            println("--------------动画完成")
            setFromMyLoc(cvPos!!)
            isAniStart = false
        }
    }


    //计算2次拿到车辆定位的时间差
    fun calTimeDiff() {
        CoroutineScope(Dispatchers.Default).launch {
            if (oldTime != 0L) {
                vehTimeDiff = System.currentTimeMillis() - oldTime
//                println("-------定位时间差 = ${vehTimeDiff}")
            }
            oldTime = System.currentTimeMillis()
        }
    }

    //设置前一个点
    private fun setFromMyLoc(myloc: VehiclePos) {
        if (fromLoc == null) {
            fromLoc = VehiclePos()
        }
        fromLoc!!.run {
            this.lat = myloc.lat
            this.lng = myloc.lng
            this.heading = myloc.heading
            this.evel = myloc.evel
        }
    }

    /**
     * 停止车辆移动
     */
    fun stopCar() {
        stopCar = true
    }


    /**
     * 设置车辆移动路径
     * @param carNavPath
     */
    fun setCarNaiPath(carNavPath: CarNavPath) {
        HighMap.setCarNavPath(carNavPath)
    }

    /**
     * 清除导航路径
     */
    fun clearCarNaiPath() {
        var carNavPath = CarNavPath()
        HighMap.setCarNavPath(carNavPath)
    }

}