package com.sd.api.maps.proxyintfaces

import com.sd.api.ui.MapReadyView

interface IGesture {

    /**
     * 设置地图旋转手势是否可用
     * @param mapReadView 地图准备就绪视图对象
     * @param enable 是否启用旋转手势功能
     */
    fun setRotateGesturesEnabled(mapReadView: MapReadyView?, enable: Boolean)


    /**
     * 设置地图倾斜手势功能的启用状态
     * @param mapReadView 地图准备就绪视图对象
     * @param enable 是否启用倾斜手势功能，true为启用，false为禁用
     * */
    fun setTiltGesturesEnabled(mapReadView: MapReadyView?, enable: Boolean)
}