package com.sd.api.maps.mine

import android.content.Intent
import android.graphics.Point
import com.minedata.minenavi.map.MineMap
import com.minedata.minenavi.map.Model
import com.minedata.minenavi.map.ModelOptions
import com.minedata.minenavi.map.Overlay
import com.minedata.minenavi.mapdal.DataPreference
import com.minedata.minenavi.mapdal.LatLng
import com.minedata.minenavi.navi.GuidanceText
import com.minedata.minenavi.navi.NaviProgressData
import com.minedata.minenavi.navi.NaviSession
import com.minedata.minenavi.navi.NaviSessionData
import com.minedata.minenavi.navi.NaviSessionParams
import com.minedata.minenavi.navi.RouteBase
import com.minedata.minenavi.navi.RouteExplorer
import com.minedata.minenavi.navi.SmoothNaviData
import com.minedata.minenavi.navi.TmcSections
import com.minedata.minenavi.tts.NaviSpeaker
import com.minedata.minenavi.util.Tools
import com.sd.api.UserCtx
import com.sd.api.bean.WayPoi
import com.sd.api.intfaces.MyMineNaviListener
import com.sd.api.intfaces.OnNaviPresenterListener
import com.sd.api.maps.cdata.MSLatLng
import com.sd.api.ui.MapReadyView
import com.sd.api.ui.MineNaiDirActivity

/**
 * 四维导航
 */
object MineNai {

    //初始化四维导航对象
    private var mNaviSession: NaviSession? = null

    // 导航小车
    var mMapCar: Model? = null
    private var mMineMap: MineMap? = null


//    var onNaviPresenterListener: OnNaviPresenterListener? = null
    /**四维导航监听回调***/
    private var mOnNaviListeners = mutableListOf<OnNaviPresenterListener?>()

    fun addNaviListener(listener: OnNaviPresenterListener?) {
        mOnNaviListeners.add(listener)
    }

    fun init() {
        mNaviSession = NaviSession.getInstance()
        mNaviSession?.enableSound(true)
        var naviSessionParams = NaviSessionParams().apply {
            autoReroute = true
            autoRemoveRoute = true
//            useMineNaviGPS = true
        }
        var context = UserCtx.Companion.instance.mContext
        mNaviSession!!.init(context, naviSessionParams)
        mNaviSession?.setDataPreference(DataPreference.preferOnline)
        mNaviSession?.addMineNaviListener(myMineNaviListener)
    }

    /**
     * 开启四维导航 客户端自实现数据回调
     */
    fun startNavi(mapReadView: MapReadyView?, onNaviPresenterListener: OnNaviPresenterListener?) {
        var mRouteBas = MineRoutePlans.mRouteBase
        if (mRouteBas != null) {
            addNaviListener(onNaviPresenterListener)
            mMineMap = mapReadView?.mMineMap
//            drawNavingCar(MineRoutePlans.mStartPoint)
            mNaviSession?.takeRoute(mRouteBas)
        }
    }

    fun startSimNavi(
        mapReadView: MapReadyView?,
        starPoint: MSLatLng,
        routeBase: RouteBase?,
        onNaviPresenterListener: OnNaviPresenterListener?
    ) {
        if (routeBase != null) {
            addNaviListener(onNaviPresenterListener)
            mMineMap = mapReadView?.mMineMap
            val point = Tools.latLngToPoint(LatLng(starPoint.lat, starPoint.lng))
            drawNavingCar(point)
            NaviSpeaker.stop()
            mNaviSession?.takeRouteQuietly(routeBase)
            // 设置速度
            mNaviSession?.setEmulatorNaviSpeed(5.0f)
            // 开始导航
            mNaviSession?.startSimulation()
        }
    }

    /**
     * 直接跳转页面开启导航
     */
    fun startNaviDirect(
        starPoint: MSLatLng,
        startName: String = "当前位置",
        endPoint: MSLatLng,
        endName: String = "",
        ways: List<WayPoi>
    ) {
        var params = MineNaiParams(starPoint, startName, endPoint, endName, ways)
        var context = UserCtx.Companion.instance.mContext

        var inten = Intent(context, MineNaiDirActivity::class.java)
        inten.putExtra("mineNaiParams", params)
        context?.startActivity(inten)
    }


    /**
     * 直接使用RouteBase开启导航
     */
    fun startNaviFormRouteBase(
        routeBase: RouteBase?,
        mStartPoint: MSLatLng,
        mapReadView: MapReadyView?
    ) {
//            mMineMap = mapReadView?.mMineMap
        if (routeBase == null)
            return
        mMineMap = mapReadView?.mMineMap
//        mNaviSession?.removeMineNaviListeners()
//        mNaviSession?.addMineNaviListener(myMineNaviListener)
        val starPoint = Tools.latLngToPoint(LatLng(mStartPoint.lat, mStartPoint.lng))
        drawNavingCar(starPoint)
        mNaviSession?.takeRoute(routeBase)
    }

    fun stopNavi() {
        mNaviSession?.removeRoute()
    }


    /**
     * 添加导航小车
     */
    fun drawNavingCar(point: Point) {
        if (mMineMap == null) {
            return
        }
        if (mMapCar == null) {
            val modelOptions = ModelOptions() // 模型文件相对路径
                .objFile("res/3d_car.obj") // 位置
                .position(Tools.pointToLatLng(point)) // 图层布局类型
                .layer(Overlay.Layer.aboveMarker) // 方向角
                .heading(0f) // 保持尺寸的比例尺
                .keepScaleSize(8.0f) // 缩放因子
                .scaleFactor(0.15f) // 可见性
                .visible(true)
            mMapCar = mMineMap?.addModel(modelOptions)
        }
    }

    /**
     * 移除导航小车
     */
    fun deleteNavingCar() {
        if (mMineMap != null && mMapCar != null) {
            mMineMap?.removeOverlay(mMapCar)
            mMapCar!!.release()
            mMapCar = null
        }
    }


    //-------------- 四维 导航监听 --------------------------
    /**
     * 四维 导航监听
     */
    private var myMineNaviListener = object : MyMineNaviListener() {
        override fun onRerouteStarted() {
            super.onRerouteStarted()
            RouteExplorer.getInstance().removeRoutes()
        }

        override fun onRerouteComplete(data: RouteBase?) {
            super.onRerouteComplete(data)
            MineRoutePlans.mRouteBase = data
            MineRoutePlans.drawPlanPath(MineRoutePlans.mRouteBase)
//            driverRouteBean.routeBase=mRouteBase
        }

        override fun onTracking(data: NaviSessionData) {
//            super.onTracking(data)
            mOnNaviListeners.forEach {
                it?.onTracking(data.travelledDistance.toFloat() / data.routeLength)
            }
        }

        override fun onSmoothTracking(data: SmoothNaviData) {
//            super.onSmoothTracking(data)
            mOnNaviListeners.forEach {
                it?.onSmoothTracking(data)
            }
        }

        override fun onDataUpdated(naviProgressData: NaviProgressData) {
//            super.onDataUpdated(naviProgressData)
            mOnNaviListeners.forEach {
                it?.onDataUpdated(naviProgressData)
            }
        }

        override fun onTiBarUpdated(tmcSections: TmcSections) {
//            super.onTiBarUpdated(tmcSections)
            mOnNaviListeners.forEach {
                it?.onTiBarUpdated(tmcSections)
            }
        }

        override fun onTextChanged(guidanceText: GuidanceText) {
//            super.onTextChanged(guidanceText)
            mOnNaviListeners.forEach {
                it?.onTextChanged(guidanceText)
            }
        }

        override fun onDistanceChanged(distance: Int) {
//            super.onDistanceChanged(distance)
            mOnNaviListeners.forEach {
                it?.onDistanceChanged(distance)
            }
        }

        override fun onArriveDestination() {
//            super.onArriveDestination()
            mOnNaviListeners.forEach {
                it?.onArriveDestination()
            }
        }

        override fun onNaviEnded() {
//            super.onNaviEnded()
            mOnNaviListeners.forEach {
                it?.onNaviEnded()
            }
        }
    }


}