package com.sd.api.maps.amap;

import com.amap.api.maps.model.UrlTileProvider;

import java.net.MalformedURLException;
import java.net.URL;

public class HeritageScopeTileProvider extends UrlTileProvider {
    private String mRootUrl;
    private static int titleSize = 256;
    private final double initialResolution = 156543.03392804062;
    private final double originShift = 20037508.342789244;

    public HeritageScopeTileProvider(String url) {
        super(titleSize, titleSize);
        mRootUrl = url + "&service=WMS&transparent=true&&version=1.1.0&tiled=true&request=GetMap&srs=EPSG:3857&format=image/png&bbox=";
//        mRootUrl = "http://192.168.59.216:8080/smartmap/wms?service=WMS&transparent=true&&version=1.1.0&tiled=true&request=GetMap&layers=yizhuang:yizhuang_avp&srs=EPSG:3857&format=image/png&bbox=";
//        mRootUrl = "http://192.168.59.216:8080/tiles/{z}/{x}/{y}.png?layer=yizhuang:yizhuang_avp&service=WMS&transparent=true&&version=1.1.0&tiled=true&request=GetMap&srs=EPSG:3857&format=image/png&bbox=";
    }

    @Override
    public URL getTileUrl(int x, int y, int level) {
        try {
//            System.out.println("-----------x = " + x + "  y = " + y + "  level = " + level);
            String url = mRootUrl + TitleBounds2(x, y, level);
//            System.out.println("-----------url = " + url);
            return new URL(url);
        } catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return null;
    }

    private String TitleBounds(int tx, int ty, int zoom) {
        double minX = Pixels2Meters(tx * titleSize, zoom);
        double maxY = -Pixels2Meters(ty * titleSize, zoom);
        double maxX = Pixels2Meters((tx + 1) * titleSize, zoom);
        double minY = -Pixels2Meters((ty + 1) * titleSize, zoom);

        minX = Meters2Lon(minX);
        minY = Meters2Lat(minY);
        maxX = Meters2Lon(maxX);
        maxY = Meters2Lat(maxY);

        return minX + "," + Double.toString(minY) + "," + Double.toString(maxX) + "," + Double.toString(maxY) + "&width=256&height=256";
    }

    private double Pixels2Meters(int p, int zoom) {
        return p * Resolution(zoom) - originShift;
    }

    private double Resolution(int zoom) {
        return initialResolution / (Math.pow(2, zoom));
    }

    private double Meters2Lon(double mx) {
        double lon = mx * (180.0 / originShift);
        return lon;
    }

    private double Meters2Lat(double my) {
        double lat = Math.atan(Math.sinh(my / originShift)) * (180.0 / Math.PI);
        return lat;
    }


    private String TitleBounds2(int tx, int ty, int zoom) {
        double max_tile = Math.pow(2, zoom); // 当前z级的最大瓦片索引（从0开始）
        if (tx < 0 || tx >= max_tile || ty < 0 || ty >= max_tile) {
            System.out.println("-----------瓦片索引超出范围 = ");
            return "";
        }

//        -- 3. 计算EPSG:3857的bbox
        double resolution = EPSG3857.size / max_tile;  //-- 单个瓦片的宽度（米）
        double minx = EPSG3857.origin + tx * resolution;  // 左边界
        double maxy = EPSG3857.max - ty * resolution;    //-- 上边界
        double maxx = minx + resolution;            // -- 右边界
        double miny = maxy - resolution;                //-- 下边界

        return minx + "," + miny + "," + maxx + "," + maxy + "&width=256&height=256";
    }

    private static class EPSG3857 {
        static double origin = -20037508.342789244;
        //        最小x和最小y
        static double max = 20037508.342789244;
        //        最大x和最大y
        static double size = 40075016.68557849;
//        直径（2×max）
    }

}
