package com.sd.api.maps.amap

import com.amap.api.maps.CameraUpdateFactory
import com.amap.api.maps.model.CameraPosition
import com.amap.api.maps.model.LatLng
import com.sd.api.ui.MapReadyView

/**
 * 高德地图方法交互
 */
object AmapMethodAdv {

    /****
     * 改变地图中心点
     * @param mapReadView 地图准备就绪的视图对象，可能为null
     * @param lat 纬度，默认值为39.977290
     * @param lng 经度，默认值为116.337000
     * **/
    fun setMapCenter(
        mapReadView: MapReadyView?,
        lat: Double = 39.977290,
        lng: Double = 116.337000
    ) {
        //参数依次是：视角调整区域的中心点坐标、希望调整到的缩放级别、俯仰角0°~45°（垂直与地图时为0）、偏航角 0~360° (正北方为0)
        val mCameraUpdate = CameraUpdateFactory.newCameraPosition(
            CameraPosition(LatLng(lat, lng), 18f, 30f, 0f)
        )
        mapReadView?.aMap?.moveCamera(mCameraUpdate)
    }


    /**
     * 改变地图缩放级别
     * @param mapReadView 地图准备就绪的视图对象
     * @param zoom 缩放级别，值越小站得越高，默认值为13f
     * */
    fun setMapZoom(mapReadView: MapReadyView?, zoom: Float = 13f) {
        var mCameraUpdate = CameraUpdateFactory.zoomTo(zoom)
        mapReadView?.aMap?.moveCamera(mCameraUpdate)
    }


    /**
     * 获取地图缩放级别
     * @param mapReadView 地图准备就绪视图对象
     * @return 返回当前地图的缩放级别，如果地图未初始化则返回0f
     */
    fun getMapZoom(mapReadView: MapReadyView?): Float {
        // 根据不同的地图类型获取对应的缩放级别
        return mapReadView?.aMap?.cameraPosition?.zoom ?: 0f
    }


    /***设置地图显示区域**/
//    fun setMapBoundArea(mapReadView: MapReadyView?) {
//        when (MSDKInitializer.getMapType()) {
//            MAP_TYPE.MINE -> {
//                val rect = mapReadView?.mMineMap?.getBoundArea()
//                if (rect==null)
//                    return
//                val rect1 = Rect(rect.left / 2, rect.top / 2, rect.right / 2, rect.bottom / 2)
//                mapReadView.mMineMap?.setBoundArea(rect1)
//            }
//
//            MAP_TYPE.AMAP -> {
//
//            }
//        }
//    }


//    /****改变地图显示区域**/
//    fun setMapZoom(mapReadView: MapReadyView?, zoom: Float=16f) {
//        when (MSDKInitializer.getMapType()) {
//            MAP_TYPE.MINE -> {
//                mapReadView?.mMineMap?.setZoomLevel(zoom)
//            }
//
//            MAP_TYPE.AMAP -> {
//                var mCameraUpdate = CameraUpdateFactory.zoomTo(zoom)
//                mapReadView?.aMap?.moveCamera(mCameraUpdate)
//            }
//        }
//    }


}