package com.sd.api.maps

import com.amap.api.maps.model.TileOverlay
import com.amap.api.maps.model.TileOverlayOptions
import com.sd.api.MAP_TYPE
import com.sd.api.MSDKInitializer
import com.sd.api.location.MineGpsLocation
import com.sd.api.maps.amap.AmapGpsLocation
import com.sd.api.maps.amap.HeritageScopeTileProvider
import com.sd.api.ui.MapReadyView

/**
 * 加载Wms地图
 */
object WmsLayer : MsOperationParent() {

    private var wmsOverlay: TileOverlay? = null

    /**
     * Load wms layer
     * @param url wms地址
     */
    fun loadWmsLayer(url: String) {
        var mapReadView = getMapReadView()
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
            }

            MAP_TYPE.AMAP -> {
                val tileProvider = HeritageScopeTileProvider(url)
                var aMap = mapReadView?.aMap
                wmsOverlay =
                    aMap?.addTileOverlay(TileOverlayOptions().tileProvider(tileProvider).zIndex(1f))
            }
        }
    }


    fun removeWmsLayer() {
        wmsOverlay?.remove()
    }
}