package com.sd.api.maps

import com.sd.api.MAP_TYPE
import com.sd.api.MSDKInitializer
import com.sd.api.ui.MapReadyView
import com.sd.api.maps.amap.AmapMethodAdv
import com.sd.api.maps.mine.MineMethodAdv

/**
 * 地图方法交互
 *
 * @constructor Create empty Method adv pro
 */
object MethodAdv : MsOperationParent(){

    /**
     * 改变地图中心点
     * @param mapReadView 地图准备就绪的视图对象
     * @param lat 纬度
     * @param lng 经度
     * **/
    fun setMapCenter(
        lat: Double,
        lng: Double
    ){
        var mapReadView = getMapReadView()
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                MineMethodAdv.setMapCenter(mapReadView, lat, lng)
            }

            MAP_TYPE.AMAP -> {
                AmapMethodAdv.setMapCenter(mapReadView, lat, lng)
            }
        }
    }


    /**
     * 改变地图缩放级别
     * @param mapReadView 地图准备就绪的视图对象
     * @param zoom 缩放级别，值越小站得越高，默认值为11f
     * */
    fun setMapZoom(zoom: Float = 11f){
        var mapReadView = getMapReadView()
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                MineMethodAdv.setMapZoom(mapReadView, zoom)
            }

            MAP_TYPE.AMAP -> {
                AmapMethodAdv.setMapZoom(mapReadView, zoom)
            }
        }
    }

}