plugins {
    alias(libs.plugins.android.library)
    alias(libs.plugins.kotlin.android)
    id("kotlin-kapt")
//    kotlin("jvm") version "2.1.10"
    id("kotlin-parcelize")
//    id("maven-publish")
//    signing
//    id ("org.jreleaser") version "1.20.0"//JReleaser now has support for publishing via the Central Publisher Portal and can be used via their Gradle plugin integration.
    id("org.jetbrains.dokka") version "2.0.0"
}


android {
    namespace = "com.sd.api"
    compileSdk = 35

    defaultConfig {
        minSdk = 29

        testInstrumentationRunner = "androidx.test.runner.AndroidJUnitRunner"
        consumerProguardFiles("consumer-rules.pro")
    }

    buildTypes {
        release {
            isMinifyEnabled = false
            proguardFiles(
                getDefaultProguardFile("proguard-android-optimize.txt"),
                "proguard-rules.pro"
            )
        }
    }
    compileOptions {
        sourceCompatibility = JavaVersion.VERSION_11
        targetCompatibility = JavaVersion.VERSION_11
    }
    kotlinOptions {
        jvmTarget = "11"
    }
    buildFeatures {
//        dataBinding = true
        viewBinding = true
    }
}


dependencies {
    implementation(fileTree(mapOf("dir" to "libs", "include" to listOf("*.jar", "*.aar"))))
    implementation(libs.androidx.core.ktx)
    implementation(libs.androidx.appcompat)
    implementation(libs.material)
    implementation(libs.androidx.constraintlayout)
    implementation(libs.androidx.activity)
    testImplementation(libs.junit)
    androidTestImplementation(libs.androidx.junit)
    androidTestImplementation(libs.androidx.espresso.core)

    api(project(":maplibs"))
//    Webview交互
    api("com.github.lzyzsd:jsbridge:1.0.4")

    //四维高精地图依赖
//    implementation("daohang.tingche.unityLibrary:adas:1.0")

    //高德
//    implementation("com.amap.api:navi-3dmap:latest.integration")
//    implementation("com.amap.api:search:latest.integration")
    //网络
    implementation("com.squareup.okhttp3:okhttp:3.12.0")
    implementation("com.google.code.gson:gson:2.8.6")
    // 权限请求框架
    implementation("com.guolindev.permissionx:permissionx:1.8.1")
    // ViewModel
    implementation("androidx.lifecycle:lifecycle-viewmodel-ktx:2.6.2")
    //fragment-ktx
    implementation("androidx.fragment:fragment-ktx:1.8.0")
}

//group = "msmap"
//version = "1.0"


//publishing {
//    publications {
//        create<MavenPublication>("maplib") {
//            groupId = "io.github.killcow"
//            artifactId = "ms-map"
//            version = "1.0.0"
//
//            // 如果是Android库模块
//            artifact(layout.buildDirectory.dir("outputs/aar/maplibrary-release.aar"))
//            // 如果是Java库模块
//            // artifact("$buildDir/libs/your-library.jar")
//            //发布到本地仓库
//            repositories {
//                maven {
//                    name = "MyRepo"
//                    url = uri(layout.buildDirectory.dir("repo"))
//                }
//
//            }
//        }
//    }
//}

//signing {
////    val signingKey: String=findProperty("signing.keyId")
//    val signingPassword: String? by project
//    useInMemoryPgpKeys(findProperty("signing.keyId").toString(), findProperty("signing.password").toString())
////
//    sign(publishing.publications["maplib"])
//}


