package com.sd.demo.ui

import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import androidx.lifecycle.lifecycleScope
import com.google.gson.Gson
import com.sd.api.highmap.AllLine
import com.sd.api.highmap.CarNavPath
import com.sd.api.highmap.HighMap
import com.sd.api.highmap.UnityPtc
import com.sd.api.highmap.WarnPtc
import com.sd.api.maps.MSCalcuMapUtil
import com.sd.api.maps.cdata.MSLatLng
import com.sd.api.scenario.CucsVehicle
import com.sd.api.scenario.VehiclePos
import com.sd.api.ui.MapMultiView.OnMapReadyLis
import com.sd.api.ui.MapReadyView
import com.sd.demo.bean.mock.MRoutes
import com.sd.demo.bean.mock.PerceptionBean
import com.sd.demo.databinding.ActivityHighMapBinding
import com.sd.demo.utils.FileIoUtils
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch
import kotlin.math.absoluteValue

/**
 *
 */
class THighMapActivity : AppCompatActivity() {

    private lateinit var binding: ActivityHighMapBinding

    var mapReadView: MapReadyView? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
//        enableEdgeToEdge()
        binding = ActivityHighMapBinding.inflate(layoutInflater)
        setContentView(binding.root)
        binding.mapMultiView.addMapRenderCallback(object : OnMapReadyLis {
            override fun onMapReady(mapReadyView: MapReadyView) {
                this@THighMapActivity.mapReadView = mapReadyView
                //传入3d tile加载地图 1= 亦庄示范区
                HighMap.setTileInit(1)
            }
        })

        setListener()
    }


    private fun setListener() {
        binding.bt1.setOnClickListener { mockCarMove() }
        binding.bt2.setOnClickListener { mockPreTarget() }
        binding.bt3.setOnClickListener { mWarnCar() }
        binding.bt4.setOnClickListener { mWarnPeo() }
    }


    private fun mockCarMove() {
        lifecycleScope.launch {
            var gson = Gson()
            var str =
                FileIoUtils.getAsset(this@THighMapActivity, "mock/Car_fangzhen.txt")
            val mRoutes = gson.fromJson<MRoutes>(str, MRoutes::class.java)
            //画出全局路径
            var lines = mRoutes.rs.map {
                AllLine(it[1], it[0])
            }
//            HighMapApi.setCarNavPath(lines, showdistance = 200)
            var carNavPath = CarNavPath().apply {
                this.lines = lines
            }
            //设置全局路径
            CucsVehicle.setCarNaiPath(carNavPath)
            //模拟车辆移动
            var head = 0.0
            var oldHead = 0.0
            var bearing = 0.0
            mRoutes.rs.forEachIndexed { index, it ->
                if (index > 0) {
                    var p1 = mRoutes.rs.get(index - 1)
                    var pc = mRoutes.rs.get(index)
                    head = MSCalcuMapUtil.calculateBearing(
                        MSLatLng(p1[1], p1[0]),
                        MSLatLng(pc[1], pc[0])
                    )
                    if ((head - oldHead).absoluteValue < 45) {
                        bearing = head
                    }
                    VehiclePos.instance.apply {
                        lat = pc[1]
                        lng = pc[0]
                        heading = bearing
                        evel = 20.80189
                    }
                }
                if (index>10){
                    CucsVehicle.clearCarNaiPath()
                }
//                HighMapApi.setCarPosition(head, it[1], it[0], 20.80189)
                CucsVehicle.moveCar(VehiclePos.instance, 1)
                oldHead = head
                delay(300)
            }
        }
    }

    private fun mockPreTarget() {
        lifecycleScope.launch {
            var gson = Gson()
            val dst = mutableListOf<String>()
            FileIoUtils.getAssetMock(this@THighMapActivity, "mock/AvpPre.txt", dst)
            dst.forEachIndexed { index, str ->
                val perceptionBean =
                    gson.fromJson<PerceptionBean>(str, PerceptionBean::class.java)
                var parts = perceptionBean.flatMap { it -> it.participants }
                //将感知物转成API能用的类型
                var pres = parts.map { it ->
                    UnityPtc().apply {
                        ptcid = it.ptcId
                        if (it.ptcType == "car") {
                            pType = 1
                        } else if (it.ptcType == "pedestrian") {
                            pType = 2
                        }
                        lat = it.latitude
                        lon = it.longitude
                        heading = it.heading
                    }
                }
                HighMap.setPtcData(pres)

                delay(1000)
            }
        }
    }


    //预警车
    fun mWarnCar() {
        //气泡消息
        startWarning("f117fdfa-feff-0100-85dc-35850000acb0")
    }

    //预警人
    fun mWarnPeo() {
        startWarning("50332456-3030-3030-3530-303334533955")
    }

    //开启预警特效
    fun startWarning(ptcId: String) {
        lifecycleScope.launch {
            var warnPtc = WarnPtc().apply {
                ptcid = ptcId
                isRed = true
            }
            var warns = listOf(warnPtc)
            HighMap.setWarnPtc(warns)
            delay(5000)
            warnPtc.isRed = false
            HighMap.setWarnPtc(warns)
        }
        toggleCircleRadar(2)
    }


    /**开启预警（光圈和雷达）
     * @param dirent  0=关闭  1=左前 2=正前 3=右前   4=右后  5=正后  6=左后
     * */
    fun toggleCircleRadar(dirent: Int) {
        HighMap.setCarBottomCircle(true)
        HighMap.setCarRadarDirection(dirent)
        lifecycleScope.launch {
            delay(5000)
            HighMap.setCarBottomCircle(false)
            HighMap.setCarRadarDirection(0)
        }
    }


}