package com.sd.demo.ui

import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import androidx.lifecycle.lifecycleScope
import com.google.gson.Gson
import com.sd.api.parkroad.RoadPos
import com.sd.api.maps.MSCalcuMapUtil
import com.sd.api.maps.cdata.MSLatLng
import com.sd.api.parkroad.MsParkRoad
import com.sd.api.parkroad.OnPrAddCar
import com.sd.api.parkroad.PartType
import com.sd.api.parkroad.PtcBean
import com.sd.api.scenario.CucsVehicle
import com.sd.api.scenario.VehiclePos
import com.sd.api.ui.MapMultiView.OnMapReadyLis
import com.sd.api.ui.MapReadyView
import com.sd.demo.bean.mock.MRoutes
import com.sd.demo.bean.mock.PerceptionBean
import com.sd.demo.databinding.ActivityPartRoadBinding
import com.sd.demo.utils.FileIoUtils
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch
import kotlin.coroutines.cancellation.CancellationException
import kotlin.math.absoluteValue

/**局部图**/
class PartRoadActivity : AppCompatActivity() {

    private lateinit var binding: ActivityPartRoadBinding
    var mapReadView: MapReadyView? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityPartRoadBinding.inflate(layoutInflater)
        setContentView(binding.root)

        binding.mapMultiView.addMapRenderCallback(object : OnMapReadyLis {
            override fun onMapReady(mapReadyView: MapReadyView) {
                this@PartRoadActivity.mapReadView = mapReadyView
                //初始化局部视图控制器
                MsParkRoad.setCarRoadVM(mapReadView)
            }
        })
        setLis()
    }

    private fun setLis() {
//        MsParkRoad.preloadMainCar(assets, "models/truck.glb")
        //主车移动
        binding.bt1.setOnClickListener {
            mockFzLine()
        }
        // 添加底部光圈
        binding.bt2.setOnClickListener {
            MsParkRoad.showWarningCircle(true)
        }
        //设置感知物显示距离
        binding.bt3.setOnClickListener {
            MsParkRoad.setDistanceVisible(100.0)
        }
        //跟车视角
        binding.bt4.setOnClickListener {
            MsParkRoad.setCameraPosition(25.0)
        }
        //人行道
        binding.bt5.setOnClickListener {
            lifecycleScope.launch {
                MsParkRoad.showWalkLine(true)
                delay(2000)
                MsParkRoad.showWalkLine(false)
            }
        }
        //mark点
        binding.bt6.setOnClickListener {
            lifecycleScope.launch {
                MsParkRoad.showMarker(1)
                delay(2000)
                MsParkRoad.showMarker(2)
                delay(2000)
                MsParkRoad.showMarker(3)
                delay(2000)
                MsParkRoad.showMarker(0)
                delay(2000)
                MsParkRoad.showMarker(-1)
            }
        }
        //预警雷达
        binding.bt7.setOnClickListener {
            lifecycleScope.launch {
                MsParkRoad.toggleRadar(true)
                delay(2000)
                MsParkRoad.toggleRadar(false)
            }
        }
        //加载感知物
        binding.bt8.setOnClickListener {
            mockPreTarget()
        }
        //预警车
        binding.bt9.setOnClickListener {
            lifecycleScope.launch {
                MsParkRoad.warnAlerm("f117fdfa-feff-0100-85dc-35850000acb1", true, 0)
                delay(5000)
                MsParkRoad.warnAlerm("f117fdfa-feff-0100-85dc-35850000acb1", false, 0)
            }
        }
        //清除感知物
        binding.bt10.setOnClickListener {
//            MsParkRoad.warnAlerm("50332456-3030-3030-3530-303334533954", true, 5)
            MsParkRoad.clearAllTargets()
        }
        //预加载主车
        binding.bt11.setOnClickListener {
//            println("-----点击预加载模型")
            MsParkRoad.preloadMainCar(assets, "car.glb")
        }
        //预加载感知物
        binding.bt12.setOnClickListener {
            MsParkRoad.preloadParticipant(assets, "truck.glb", PartType.CAR)
            MsParkRoad.preloadParticipant(assets, "passenger.glb", PartType.PEOPLE)
        }
    }

    fun mockFzLine() {
        lifecycleScope.launch {
            try {
                var gson = Gson()
                var str = FileIoUtils.getAsset(this@PartRoadActivity, "mock/Car_fangzhen1.txt")
                //获取车辆位姿
                val mRoutes = gson.fromJson<MRoutes>(str, MRoutes::class.java)
                var head = 0.0
                var oldHead = 0.0
                mRoutes.rs.forEachIndexed { index, it ->
//                    println("---------it[0] = ${it[0]}  it[1] = ${it[1]}  index = ${index}")
                    if (index > 0) {
                        var p1 = mRoutes.rs.get(index - 1)
                        var pc = mRoutes.rs.get(index)
                        head = MSCalcuMapUtil.calculateBearing(
                            MSLatLng(p1[1], p1[0]),
                            MSLatLng(pc[1], pc[0])
                        )
                        VehiclePos.instance.apply {
                            lat = pc[1]
                            lng = pc[0]
                            if ((head - oldHead).absoluteValue < 45) {
                                heading = head
                            }
//                            evel = 20.80189
                        }

                        CucsVehicle.moveCar(VehiclePos.instance, 2)
                        //更新车辆位置.主车是否添加回调
//                        MsParkRoad.updateMainCar(RoadPos.instance, object : OnPrAddCar {
//                            override fun onPrAddCar(isAdd: Boolean) {
//                                println("------------isAdd = ${isAdd}")
//                            }
//                        })
                        oldHead = head
                        delay(600)
                    }
                }
            } catch (e: CancellationException) {

            }
        }
    }

    fun mockPreTarget() {
        lifecycleScope.launch {
            try {
                var gson = Gson()
                val dst = mutableListOf<String>()
                FileIoUtils.getAssetMock(this@PartRoadActivity, "mock/PerTarget.txt", dst)

                dst.forEachIndexed { index, str ->
                    val perceptionBean =
                        gson.fromJson<PerceptionBean>(str, PerceptionBean::class.java)
                    var parts = perceptionBean.flatMap { it -> it.participants }
                    //转化sdk可用的感知物
                    var pres = parts.map { it ->
                        PtcBean().apply {
                            ptcId = it.ptcId
                            if (it.ptcType == "car") {
                                ptcType = 1
                            } else if (it.ptcType == "pedestrian") {
                                ptcType = 2
                            } else {
                                ptcType = 1
                            }
                            lat = it.latitude
                            lng = it.longitude
                            heading = it.heading
                        }
                    }
                    MsParkRoad.upDatePreTarget(pres)
                    delay(1000)
                }
            } catch (e: CancellationException) {

            }
        }
    }

}