package com.sd.demo.ui

import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import androidx.lifecycle.lifecycleScope
import com.google.gson.Gson
import com.sd.api.maps.MSCalcuMapUtil
import com.sd.api.maps.MethodAdv
import com.sd.api.maps.cdata.MSLatLng
import com.sd.api.scenario.CucsVehicle
import com.sd.api.scenario.VehicleModel
import com.sd.api.scenario.VehiclePos
import com.sd.api.ui.MapMultiView.OnMapReadyLis
import com.sd.api.ui.MapReadyView
import com.sd.demo.bean.mock.MRoutes
import com.sd.demo.databinding.ActivityOnLineMapBinding
import com.sd.demo.ui.PartRoadActivity
import com.sd.demo.utils.FileIoUtils
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch
import kotlin.coroutines.cancellation.CancellationException
import kotlin.math.absoluteValue

//测试在线地图业务
class OnLineMapActivity : AppCompatActivity() {

    private lateinit var binding: ActivityOnLineMapBinding

    var mapReadView: MapReadyView? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityOnLineMapBinding.inflate(layoutInflater)
        setContentView(binding.root)

        binding.mapMultiView.addMapRenderCallback(object : OnMapReadyLis {
            override fun onMapReady(mapReadyView: MapReadyView) {
                this@OnLineMapActivity.mapReadView = mapReadyView
            }
        })

        setListener()
    }

    private fun setListener() {
        binding.bt1.setOnClickListener {
//            //移动网联车
            mockFzLine()

        }
    }

    fun mockFzLine() {
        lifecycleScope.launch {
            try {
                var gson = Gson()
                var str = FileIoUtils.getAsset(this@OnLineMapActivity, "mock/Car_fangzhen1.txt")
                //获取车辆位姿
                val mRoutes = gson.fromJson<MRoutes>(str, MRoutes::class.java)
                var head = 0.0
                var oldHead = 0.0
                mRoutes.rs.forEachIndexed { index, it ->
//                    println("---------it[0] = ${it[0]}  it[1] = ${it[1]}  index = ${index}")
                    if (index > 0) {
                        var p1 = mRoutes.rs.get(index - 1)
                        var pc = mRoutes.rs.get(index)
                        head = MSCalcuMapUtil.calculateBearing(
                            MSLatLng(p1[1], p1[0]),
                            MSLatLng(pc[1], pc[0])
                        )
                        VehiclePos.instance.apply {
                            lat = pc[1]
                            lng = pc[0]
                            if ((head - oldHead).absoluteValue < 45) {
                                heading = head
                            }
                        }
                        CucsVehicle.moveCar(VehiclePos.instance, 3)
                        MethodAdv.setMapCenter(VehiclePos.instance.lat,  VehiclePos.instance.lng)
                        oldHead = head
                        delay(600)
                    }
                }
            } catch (e: CancellationException) {

            }
        }
    }

}